/*
 * Decompiled with CFR 0.152.
 */
package org.archive.net;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.archive.util.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicSuffixes {
    protected static Pattern topmostAssignedSurtPrefixPattern;
    protected static String topmostAssignedSurtPrefixRegex;

    public static void main(String[] args) throws IOException {
        BufferedWriter writer;
        String regex;
        if (args.length == 0 || "=".equals(args[0])) {
            regex = PublicSuffixes.getTopmostAssignedSurtPrefixRegex();
        } else {
            BufferedReader reader = new BufferedReader(new FileReader(args[0]));
            regex = PublicSuffixes.getTopmostAssignedSurtPrefixRegex(reader);
            IOUtils.closeQuietly((Reader)reader);
        }
        boolean needsClose = false;
        if (args.length >= 2) {
            writer = new BufferedWriter(new FileWriter(args[1]));
            needsClose = true;
        } else {
            writer = new BufferedWriter(new OutputStreamWriter(System.out));
        }
        writer.append(regex);
        writer.flush();
        if (needsClose) {
            writer.close();
        }
    }

    public static List<String> readPublishedFileToSurtList(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> list = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("//")) continue;
            line = line.split("\\s+")[0];
            line = line.toLowerCase();
            String[] segs = line.split("\\.");
            StringBuilder surtregex = new StringBuilder();
            for (int i = segs.length - 1; i >= 0; --i) {
                if (segs[i].length() <= 0) continue;
                String fixed = segs[i].replaceAll("\\?", "_");
                fixed = fixed.replaceAll("!", "+");
                surtregex.append(fixed + ",");
            }
            list.add(surtregex.toString());
        }
        Collections.sort(list);
        String last = "";
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            if (s.equals(last)) {
                iter.remove();
                continue;
            }
            last = s;
        }
        return list;
    }

    private static String surtPrefixRegexFromSurtList(List<String> list) {
        StringBuilder regex = new StringBuilder();
        regex.append("(?ix)^\n");
        TreeSet<String> prefixes = new TreeSet<String>(Collections.reverseOrder());
        prefixes.addAll(list);
        prefixes.add("*,");
        PublicSuffixes.buildRegex("", regex, prefixes);
        regex.append("\n([\\-\\w]+,)");
        String rstring = regex.toString();
        rstring = rstring.replaceAll("\\*", "[\\\\-\\\\w]+");
        return rstring;
    }

    protected static void buildRegex(String stem, StringBuilder regex, SortedSet<String> prefixes) {
        if (prefixes.isEmpty()) {
            return;
        }
        if (prefixes.size() == 1 && prefixes.first().equals(stem)) {
            return;
        }
        regex.append("(?:");
        if (stem.length() == 0) {
            regex.append("\n ");
        }
        Iterator iter = prefixes.iterator();
        char c = '\u0000';
        while (iter.hasNext()) {
            String s = (String)iter.next();
            if (s.length() > stem.length()) {
                char d = s.charAt(stem.length());
                if (d == '+') {
                    regex.append("(?=" + s.substring(stem.length() + 1) + ")");
                } else {
                    if (d == c) continue;
                    c = d;
                    regex.append(c);
                    String newStem = s.substring(0, stem.length() + 1);
                    SortedSet<String> tail = prefixes.tailSet(newStem);
                    SortedSet<String> range = null;
                    for (String candidate : tail) {
                        if (candidate.equals(newStem)) continue;
                        range = prefixes.subSet(s, candidate);
                        break;
                    }
                    if (range == null) {
                        range = prefixes.tailSet(s);
                    }
                    PublicSuffixes.buildRegex(newStem, regex, range);
                }
                regex.append('|');
                continue;
            }
            regex.append('@');
        }
        regex.deleteCharAt(regex.length() - 1);
        regex.append(')');
        if (stem.length() == 1) {
            regex.append('\n');
        }
    }

    public static synchronized Pattern getTopmostAssignedSurtPrefixPattern() {
        if (topmostAssignedSurtPrefixPattern == null) {
            topmostAssignedSurtPrefixPattern = Pattern.compile(PublicSuffixes.getTopmostAssignedSurtPrefixRegex());
        }
        return topmostAssignedSurtPrefixPattern;
    }

    public static synchronized String getTopmostAssignedSurtPrefixRegex() {
        if (topmostAssignedSurtPrefixRegex == null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(PublicSuffixes.class.getClassLoader().getResourceAsStream("effective_tld_names.dat")));
            topmostAssignedSurtPrefixRegex = PublicSuffixes.getTopmostAssignedSurtPrefixRegex(reader);
            IOUtils.closeQuietly((Reader)reader);
        }
        return topmostAssignedSurtPrefixRegex;
    }

    public static String getTopmostAssignedSurtPrefixRegex(BufferedReader reader) {
        List<String> list;
        try {
            list = PublicSuffixes.readPublishedFileToSurtList(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return PublicSuffixes.surtPrefixRegexFromSurtList(list);
    }

    public static String reduceSurtToTopmostAssigned(String surt) {
        Matcher matcher = TextUtils.getMatcher(PublicSuffixes.getTopmostAssignedSurtPrefixRegex(), surt);
        if (matcher.find()) {
            surt = matcher.group();
        }
        TextUtils.recycleMatcher(matcher);
        return surt;
    }
}

