/*
 * Decompiled with CFR 0.152.
 */
package org.archive.net.s3;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;

public class S3URLConnection
extends URLConnection {
    String id = "";
    String secret = "";
    S3Object object = null;

    public S3URLConnection(URL url) {
        super(url);
        String[] userInfo = url.getUserInfo().split(":");
        if (userInfo != null) {
            this.id = userInfo[0];
            this.secret = userInfo[1];
        }
    }

    public void connect() throws IOException {
        try {
            AWSCredentials credentials = new AWSCredentials(this.id, this.secret);
            RestS3Service service = new RestS3Service(credentials);
            S3Bucket bucket = new S3Bucket(this.url.getHost());
            this.object = service.getObject(bucket, this.url.getPath().substring(1));
        }
        catch (S3ServiceException s3e) {
            s3e.printStackTrace();
            throw new IOException("Error connecting to S3: " + s3e.getStackTrace());
        }
    }

    public String getContentType() {
        return "arc";
    }

    public InputStream getInputStream() throws IOException {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.object.getDataInputStream();
        }
        catch (S3ServiceException s3e) {
            s3e.printStackTrace();
            throw new IOException("Error reading from S3: " + s3e.getStackTrace());
        }
    }
}

