/*
 * Decompiled with CFR 0.152.
 */
package org.archive.openmbeans.annotations;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import org.archive.openmbeans.annotations.Metadata;

public class Bean
implements DynamicMBean,
NotificationEmitter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ACTION = 1;
    public static final int INFO = 0;
    public static final int ACTION_INFO = 2;
    private final AtomicLong sequenceNumber = new AtomicLong();
    private static final Map<Class, Metadata> METADATA = new HashMap<Class, Metadata>();
    private transient Metadata metadata;
    private final Object target;
    private transient NotificationBroadcasterSupport emitter;

    public Bean(DynamicMBean target) {
        this(target, target.getClass());
    }

    public Bean(DynamicMBean target, Class c) {
        this.target = target;
        this.metadata = Bean.getInfo(c);
        this.emitter = new NotificationBroadcasterSupport();
    }

    public Bean(Class c) {
        this.target = this;
        this.metadata = Bean.getInfo(c);
        this.emitter = new NotificationBroadcasterSupport();
    }

    public Bean() {
        this.target = this;
        this.metadata = Bean.getInfo(this.getClass());
        this.emitter = new NotificationBroadcasterSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Metadata getInfo(Class c) {
        Map<Class, Metadata> map = METADATA;
        synchronized (map) {
            Metadata result = METADATA.get(c);
            if (result != null) {
                return result;
            }
            result = new Metadata(c);
            METADATA.put(c, result);
            return result;
        }
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, ReflectionException {
        Method a = this.metadata.getAccessor(attribute);
        try {
            return a.invoke(this.target, new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList(attributes.length);
        for (String s : attributes) {
            try {
                result.add(new Attribute(s, this.getAttribute(s)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public MBeanInfo getMBeanInfo() {
        return this.metadata.getOpenMBeanInfo();
    }

    public Object invoke(String actionName, Object[] params, String[] sig) throws MBeanException, ReflectionException {
        Method m = this.metadata.getOperation(actionName);
        if (m == null) {
            return null;
        }
        try {
            return m.invoke(this.target, params);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            t.printStackTrace();
            if (t instanceof Exception) {
                Exception te = (Exception)t;
                throw new ReflectionException(te);
            }
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, ReflectionException {
        Method m = this.metadata.getMutator(attribute.getName());
        if (m == null) {
            throw new AttributeNotFoundException();
        }
        try {
            m.invoke(this.target, attribute.getValue());
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        for (Object o : attributes) {
            try {
                Attribute a = (Attribute)o;
                this.setAttribute(a);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return attributes;
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener, filter, handback);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.emitter.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.metadata.getOpenMBeanInfo().getNotifications();
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    public void sendNotification(Notification n) {
        this.emitter.sendNotification(n);
    }

    public void sendNotification(String type, String message) {
        Notification n = new Notification(type, this, this.sequenceNumber.getAndIncrement(), System.currentTimeMillis(), message);
        this.sendNotification(n);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.metadata.getOpenMBeanInfo().getClassName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String className = in.readUTF();
        Class<?> c = Class.forName(className);
        this.metadata = Bean.getInfo(c);
        this.emitter = new NotificationBroadcasterSupport();
    }
}

