/*
 * Decompiled with CFR 0.152.
 */
package org.archive.openmbeans.annotations;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.archive.openmbeans.annotations.Zen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanProxy
implements InvocationHandler {
    private final MBeanServerConnection connection;
    private final ObjectName oname;
    private final MBeanInfo info;

    public BeanProxy(MBeanServerConnection connection, ObjectName oname) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        this.connection = connection;
        this.oname = oname;
        this.info = connection.getMBeanInfo(oname);
    }

    @Override
    public Object invoke(Object target, Method method, Object[] args) throws Throwable {
        if (args == null) {
            args = new Object[]{};
        }
        if (Zen.isAccessor(method)) {
            String attr = Zen.getAttributeName(method.getName());
            return this.connection.getAttribute(this.oname, attr);
        }
        if (Zen.isMutator(method)) {
            String attrName = Zen.getAttributeName(method.getName());
            Attribute attr = new Attribute(attrName, args[0]);
            this.connection.setAttribute(this.oname, attr);
            return null;
        }
        MBeanOperationInfo info = this.getOperation(method);
        String[] sig = new String[args.length];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = info.getSignature()[i].getType();
        }
        return this.connection.invoke(this.oname, method.getName(), args, sig);
    }

    private MBeanOperationInfo getOperation(Method method) {
        String name = method.getName();
        int plength = method.getParameterTypes().length;
        for (MBeanOperationInfo oi : this.info.getOperations()) {
            if (!oi.getName().equals(name) || oi.getSignature().length != plength) continue;
            return oi;
        }
        throw new IllegalStateException("No such operation: " + method);
    }

    public static <T> T proxy(MBeanServerConnection connection, ObjectName oname, Class<T> cls) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        ClassLoader loader = cls.getClassLoader();
        BeanProxy ih = new BeanProxy(connection, oname);
        Class[] classes = new Class[]{cls};
        return cls.cast(Proxy.newProxyInstance(loader, classes, (InvocationHandler)ih));
    }
}

