/*
 * Decompiled with CFR 0.152.
 */
package org.archive.openmbeans.annotations;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.management.Notification;
import org.archive.openmbeans.annotations.Bean;
import org.archive.openmbeans.annotations.Emitter;
import org.archive.openmbeans.annotations.Header;
import org.archive.openmbeans.annotations.Operation;
import org.archive.openmbeans.annotations.Parameter;

@Header(desc="The example bean for unit testing purposes.")
public class ExampleBean
extends Bean {
    @Operation(desc="Performs a logical AND on two booleans.", impact=1)
    public boolean and(@Parameter(name="a", desc="The first boolean.", def="false") boolean a, @Parameter(name="b", desc="The second boolean.", def="false") boolean b) {
        return a && b;
    }

    @Operation(desc="Sums two bytes.", impact=1)
    public byte sumByte(@Parameter(name="a", desc="The first byte to sum.", def="0") byte a, @Parameter(name="b", desc="The second byte to sum.", def="0") byte b) {
        return (byte)(a + b);
    }

    @Operation(desc="Sums two chars.", impact=1)
    public char sumChar(@Parameter(name="a", desc="The first char to sum.", def="0") char a, @Parameter(name="b", desc="The second char to sum.", def="0") char b) {
        return (char)(a + b);
    }

    @Operation(desc="Sums two doubles.", impact=1)
    public double sumDouble(@Parameter(name="a", desc="The first double to sum.", def="0") double a, @Parameter(name="b", desc="The second double to sum.", def="0") double b) {
        return a + b;
    }

    @Operation(desc="Sums two floats.", impact=1)
    public float sumFloat(@Parameter(name="a", desc="The first float to sum.", def="0") float a, @Parameter(name="b", desc="The second float to sum.", def="0") float b) {
        return a + b;
    }

    @Operation(desc="Sums two ints.", impact=1)
    public int sumInt(@Parameter(name="a", desc="The first int to sum.", def="0") int a, @Parameter(name="b", desc="The second int to sum.", def="0") int b) {
        return a + b;
    }

    @Operation(desc="Sums two shorts.", impact=1)
    public short sumShort(@Parameter(name="a", desc="The first short to sum.", def="0") short a, @Parameter(name="b", desc="The second short to sum.", def="0") short b) {
        return (short)(a + b);
    }

    @Operation(desc="Sums two longs.", impact=1)
    public long sumLong(@Parameter(name="a", desc="The first long to sum.", def="0") long a, @Parameter(name="b", desc="The second long to sum.", def="0") long b) {
        return a + b;
    }

    @Operation(desc="Sums two BigIntegers.", impact=1)
    public BigInteger sumBigInteger(@Parameter(name="a", desc="The first BigInteger to sum.", def="0") BigInteger a, @Parameter(name="b", desc="The second BigInteger to sum.", def="0") BigInteger b) {
        return a.add(b);
    }

    @Operation(desc="Sums two BigDecimals.", impact=1)
    public BigDecimal sumBigDecimal(@Parameter(name="a", desc="The first BigDecimal to sum.", def="0") BigDecimal a, @Parameter(name="b", desc="The second BigDecimal to sum.", def="0") BigDecimal b) {
        return a.add(b);
    }

    @Operation(desc="Concatenates two strings.", impact=1)
    public String concatenate(@Parameter(name="a", desc="The first string to concatenate.", def="") String a, @Parameter(name="b", desc="The second string to concatenate.", def="") String b) {
        return a + b;
    }

    @Emitter(desc="Example notification.", types={"foo", "bar"})
    protected void emit(Notification n) {
    }
}

