/*
 * Decompiled with CFR 0.152.
 */
package org.archive.openmbeans.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenType;
import org.archive.openmbeans.annotations.Attribute;
import org.archive.openmbeans.annotations.Emitter;
import org.archive.openmbeans.annotations.Header;
import org.archive.openmbeans.annotations.OpenTypes;
import org.archive.openmbeans.annotations.Operation;
import org.archive.openmbeans.annotations.Parameter;
import org.archive.openmbeans.annotations.Zen;
import org.archive.openmbeans.factory.Attr;
import org.archive.openmbeans.factory.Info;
import org.archive.openmbeans.factory.Notif;
import org.archive.openmbeans.factory.Op;
import org.archive.openmbeans.factory.Param;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Metadata {
    private Info info;
    private OpenMBeanInfoSupport openInfo;
    private Map<String, Method> operations;
    private Map<String, Method> accessors;
    private Map<String, Method> mutators;
    private Class cls;

    public Metadata(Class<?> c) {
        this.cls = c;
        this.info = new Info();
        this.info.name = c.getName();
        Header h = c.getAnnotation(Header.class);
        if (h != null) {
            this.info.desc = h.desc();
        }
        this.operations = new HashMap<String, Method>();
        this.accessors = new HashMap<String, Method>();
        this.mutators = new HashMap<String, Method>();
        List<Method> methods = Zen.getAllMethods(c);
        for (Method m : methods) {
            this.addOperation(m);
            this.addAttribute(m);
            this.addNotification(m);
        }
        this.openInfo = this.info.make();
        this.info = null;
    }

    public Class getType() {
        return this.cls;
    }

    public OpenMBeanInfoSupport getOpenMBeanInfo() {
        return this.openInfo;
    }

    public Method getAccessor(String attributeName) {
        return this.accessors.get(attributeName);
    }

    public Method getMutator(String attributeName) {
        return this.mutators.get(attributeName);
    }

    public Method getOperation(String opName) {
        return this.operations.get(opName);
    }

    private void addAttribute(Method m) {
        Attribute anno = m.getAnnotation(Attribute.class);
        if (anno == null) {
            return;
        }
        String propName = Zen.getAttributeName(m.getName());
        Method mutator = Zen.getMutator(m.getDeclaringClass(), m);
        Class<?> type = m.getReturnType();
        Attr attr = new Attr();
        attr.name = propName;
        attr.desc = anno.desc();
        attr.read = true;
        attr.write = mutator != null;
        attr.type = OpenTypes.toOpenType(type);
        attr.def = OpenTypes.parse(m.getReturnType(), anno.def());
        attr.min = Metadata.parseMinOrMax(type, anno.min());
        attr.max = Metadata.parseMinOrMax(type, anno.max());
        for (String s : anno.legal()) {
            attr.legal.add(OpenTypes.parse(type, s));
        }
        this.info.attrs.add(attr);
        this.accessors.put(propName, m);
        if (mutator != null) {
            this.mutators.put(propName, m);
        }
    }

    private static Comparable parseMinOrMax(Class c, String v) {
        if (v.equals("")) {
            return null;
        }
        return OpenTypes.parse(c, v);
    }

    private void addOperation(Method m) {
        Operation anno = m.getAnnotation(Operation.class);
        if (anno == null) {
            return;
        }
        Op op = new Op();
        op.name = m.getName();
        op.desc = anno.desc();
        op.ret = anno.type().equals("") ? OpenTypes.toOpenType(m.getReturnType()) : Metadata.findOpenTypeField(m.getDeclaringClass(), anno.type());
        op.impact = anno.impact();
        Annotation[][] pannos = m.getParameterAnnotations();
        Class<?>[] ptypes = m.getParameterTypes();
        for (int i = 0; i < ptypes.length; ++i) {
            Parameter panno = Metadata.findParameterAnnotation(pannos[i]);
            Param param = new Param();
            if (panno == null) {
                param.name = "arg" + i;
                param.desc = "arg" + i;
            } else {
                param.name = panno.name();
                param.desc = panno.desc();
                param.def = OpenTypes.parse(ptypes[i], panno.def());
                param.min = Metadata.parseMinOrMax(ptypes[i], panno.min());
                param.max = Metadata.parseMinOrMax(ptypes[i], panno.max());
                for (String s : panno.legal()) {
                    param.legal.add(OpenTypes.parse(ptypes[i], s));
                }
            }
            param.type = panno.type().equals("") ? OpenTypes.toOpenType(ptypes[i]) : Metadata.findOpenTypeField(m.getDeclaringClass(), panno.type());
            op.sig.add(param);
        }
        this.operations.put(m.getName(), m);
        this.info.ops.add(op);
    }

    private void addNotification(Method m) {
        if (!m.getName().equals("emit")) {
            return;
        }
        if (m.getReturnType() != Void.TYPE) {
            return;
        }
        if (m.getParameterTypes().length != 1) {
            return;
        }
        Class<?> p = m.getParameterTypes()[0];
        if (!Notification.class.isAssignableFrom(p)) {
            return;
        }
        Emitter anno = m.getAnnotation(Emitter.class);
        if (anno == null) {
            return;
        }
        Notif notif = new Notif();
        notif.name = p.getName();
        notif.desc = anno.desc();
        notif.notif.addAll(Arrays.asList(anno.types()));
        this.info.notifs.add(notif);
    }

    private static Parameter findParameterAnnotation(Annotation[] arr) {
        for (Annotation a : arr) {
            if (!(a instanceof Parameter)) continue;
            return (Parameter)a;
        }
        return null;
    }

    private static OpenType findOpenTypeField(Class c, String name) {
        Field[] fields;
        int p = name.lastIndexOf(46);
        if (p >= 0) {
            String className = name.substring(0, p);
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            name = name.substring(p + 1);
        }
        for (Field f : fields = c.getFields()) {
            if (!Metadata.isOpenTypeField(f, name)) continue;
            try {
                return (OpenType)f.get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    private static boolean isOpenTypeField(Field f, String name) {
        int mods = f.getModifiers();
        if (!Modifier.isStatic(mods)) {
            return false;
        }
        if (!Modifier.isPublic(mods)) {
            return false;
        }
        if (!f.getName().equals(name)) {
            return false;
        }
        return OpenType.class.isAssignableFrom(f.getType());
    }
}

