/*
 * Decompiled with CFR 0.152.
 */
package org.archive.openmbeans.annotations;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class OpenTypes {
    private OpenTypes() {
    }

    public static OpenType toOpenType(Class c) {
        try {
            return OpenTypes.innerToOpenType(c);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
    }

    private static OpenType innerToOpenType(Class c) throws OpenDataException {
        if (c.isArray()) {
            OpenType element = OpenTypes.toOpenType(c.getComponentType());
            return new ArrayType(1, element);
        }
        if (c == Boolean.TYPE) {
            return SimpleType.BOOLEAN;
        }
        if (c == Integer.TYPE) {
            return SimpleType.INTEGER;
        }
        if (c == Double.TYPE) {
            return SimpleType.DOUBLE;
        }
        if (c == Float.TYPE) {
            return SimpleType.FLOAT;
        }
        if (c == Character.TYPE) {
            return SimpleType.CHARACTER;
        }
        if (c == Short.TYPE) {
            return SimpleType.SHORT;
        }
        if (c == Byte.TYPE) {
            return SimpleType.BYTE;
        }
        if (c == Long.TYPE) {
            return SimpleType.LONG;
        }
        if (c == Void.TYPE) {
            return SimpleType.VOID;
        }
        if (c == String.class) {
            return SimpleType.STRING;
        }
        if (c == Date.class) {
            return SimpleType.DATE;
        }
        if (c == BigDecimal.class) {
            return SimpleType.BIGDECIMAL;
        }
        if (c == BigInteger.class) {
            return SimpleType.BIGINTEGER;
        }
        if (c == ObjectName.class) {
            return SimpleType.OBJECTNAME;
        }
        if (c == Boolean.class) {
            return SimpleType.BOOLEAN;
        }
        if (c == Integer.class) {
            return SimpleType.INTEGER;
        }
        if (c == Double.class) {
            return SimpleType.DOUBLE;
        }
        if (c == Float.class) {
            return SimpleType.FLOAT;
        }
        if (c == Character.class) {
            return SimpleType.CHARACTER;
        }
        if (c == Short.class) {
            return SimpleType.SHORT;
        }
        if (c == Byte.class) {
            return SimpleType.BYTE;
        }
        if (c == Long.class) {
            return SimpleType.LONG;
        }
        if (c == Void.class) {
            return SimpleType.VOID;
        }
        throw new IllegalArgumentException(c.getName() + " is not an open type.");
    }

    public static Comparable parse(Class c, String value) {
        if (c == String.class) {
            return value;
        }
        if (value.equals("")) {
            return null;
        }
        if (c == Boolean.class || c == Boolean.TYPE) {
            return Boolean.valueOf(Boolean.parseBoolean(value));
        }
        if (c == Byte.class || c == Byte.TYPE) {
            return Byte.valueOf(Byte.parseByte(value));
        }
        if (c == Character.class || c == Character.TYPE) {
            if (value.length() != 1) {
                throw new IllegalStateException();
            }
            return Character.valueOf(value.charAt(0));
        }
        if (c == Double.class || c == Double.TYPE) {
            return Double.valueOf(Double.parseDouble(value));
        }
        if (c == Float.class || c == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return Integer.valueOf(Integer.parseInt(value));
        }
        if (c == Long.class || c == Long.TYPE) {
            return Long.valueOf(Long.parseLong(value));
        }
        if (c == Short.class || c == Short.TYPE) {
            return Short.valueOf(Short.parseShort(value));
        }
        if (c == BigInteger.class) {
            return new BigInteger(value);
        }
        if (c == BigDecimal.class) {
            return new BigDecimal(value);
        }
        throw new IllegalArgumentException(c + " is not a simple open type.");
    }
}

