/*
 * Decompiled with CFR 0.152.
 */
package org.archive.openmbeans.annotations;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zen {
    private Zen() {
    }

    public static String getAttributeName(String methodName) {
        if (methodName.startsWith("set")) {
            return methodName.substring(3).toLowerCase();
        }
        if (methodName.startsWith("get")) {
            return methodName.substring(3).toLowerCase();
        }
        if (methodName.startsWith("is")) {
            return methodName.substring(2).toLowerCase();
        }
        throw new IllegalArgumentException("Not an attribute name.");
    }

    public static boolean isMutator(Method m, String name, Class type) {
        int mods = m.getModifiers();
        if (Modifier.isStatic(mods)) {
            return false;
        }
        if (!m.getName().equals(name)) {
            return false;
        }
        Class<?>[] p = m.getParameterTypes();
        if (p.length != 1) {
            return false;
        }
        return p[0] == type;
    }

    public static Method getMutator(Class c, Method accessor) {
        String propName = Zen.getAttributeName(accessor.getName());
        String setterName = "set" + propName;
        for (Method m : c.getMethods()) {
            if (!Zen.isMutator(m, setterName, accessor.getReturnType())) continue;
            return m;
        }
        return null;
    }

    public static List<Method> getAllMethods(Class x) {
        if (x.isInterface()) {
            ArrayList<Method> r = new ArrayList<Method>();
            Zen.getAllInterfaceMethods(r, x);
            return r;
        }
        return Zen.getAllClassMethods(x);
    }

    private static List<Method> getAllClassMethods(Class x) {
        ArrayList<Method> result = new ArrayList<Method>();
        while (true) {
            for (Method m : x.getDeclaredMethods()) {
                int mods = m.getModifiers();
                if (Modifier.isPrivate(mods)) {
                    result.add(m);
                    continue;
                }
                if (Zen.contains(result, m)) continue;
                result.add(m);
            }
            if (x == Object.class) {
                return result;
            }
            x = x.getSuperclass();
        }
    }

    private static void getAllInterfaceMethods(List<Method> result, Class x) {
        for (Method method : x.getDeclaredMethods()) {
            if (Zen.contains(result, method)) continue;
            result.add(method);
        }
        for (GenericDeclaration genericDeclaration : x.getInterfaces()) {
            Zen.getAllInterfaceMethods(result, (Class)genericDeclaration);
        }
    }

    private static boolean contains(List<Method> list, Method m) {
        for (Method test : list) {
            if (test.getName().equals(m.getName()) || !Zen.same(test, m)) continue;
            return true;
        }
        return false;
    }

    private static boolean same(Method m1, Method m2) {
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        return Arrays.equals(m1.getParameterTypes(), m2.getParameterTypes());
    }

    public static boolean isAccessor(Method m) {
        int mods = m.getModifiers();
        if (!Modifier.isPublic(mods)) {
            return false;
        }
        if (Modifier.isStatic(mods)) {
            return false;
        }
        if (m.getParameterTypes().length > 0) {
            return false;
        }
        if (m.getReturnType() == Void.TYPE) {
            return false;
        }
        String name = m.getName();
        return name.startsWith("get") || name.startsWith("is");
    }

    public static boolean isMutator(Method m) {
        int mods = m.getModifiers();
        if (!Modifier.isPublic(mods)) {
            return false;
        }
        if (Modifier.isStatic(mods)) {
            return false;
        }
        if (m.getParameterTypes().length != 1) {
            return false;
        }
        if (m.getReturnType() != Void.TYPE) {
            return false;
        }
        String name = m.getName();
        return name.startsWith("set");
    }
}

