/*
 * Decompiled with CFR 0.152.
 */
package org.archive.queue;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.archive.settings.file.BdbModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredQueue<E extends Serializable>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(StoredQueue.class.getName());
    transient StoredSortedMap queueMap;
    transient Database queueDb;
    AtomicLong tailIndex = new AtomicLong(0L);
    AtomicLong headIndex = new AtomicLong(0L);

    public StoredQueue(Database db, Class clsOrNull, StoredClassCatalog classCatalog) {
        this.hookupDatabase(db, clsOrNull, classCatalog);
    }

    public void hookupDatabase(Database db, Class clsOrNull, StoredClassCatalog classCatalog) {
        TupleBinding valueBinding = TupleBinding.getPrimitiveBinding((Class)clsOrNull);
        if (valueBinding == null) {
            valueBinding = new SerialBinding((ClassCatalog)classCatalog, clsOrNull);
        }
        this.queueDb = db;
        this.queueMap = new StoredSortedMap(db, (EntryBinding)TupleBinding.getPrimitiveBinding(Long.class), (EntryBinding)valueBinding, true);
    }

    @Override
    public Iterator<E> iterator() {
        return this.queueMap.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        AtomicLong atomicLong = this.tailIndex;
        synchronized (atomicLong) {
            AtomicLong atomicLong2 = this.headIndex;
            synchronized (atomicLong2) {
                return (int)(this.tailIndex.get() - this.headIndex.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E o) {
        AtomicLong atomicLong = this.tailIndex;
        synchronized (atomicLong) {
            this.queueMap.put((Object)this.tailIndex.getAndIncrement(), o);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        AtomicLong atomicLong = this.headIndex;
        synchronized (atomicLong) {
            Serializable head = null;
            while (head == null && this.headIndex.get() < this.tailIndex.get()) {
                head = (Serializable)this.queueMap.get((Object)this.headIndex.get());
                if (head != null) {
                    return (E)head;
                }
                logger.severe("unexpected empty index of StoredQueue: " + this.headIndex.get() + " (tailIndex: " + this.tailIndex.get());
                this.headIndex.incrementAndGet();
            }
            return (E)head;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        AtomicLong atomicLong = this.headIndex;
        synchronized (atomicLong) {
            Object head = this.peek();
            if (head != null) {
                return (E)((Serializable)this.queueMap.remove((Object)this.headIndex.getAndIncrement()));
            }
            return null;
        }
    }

    public static BdbModule.BdbConfig databaseConfig() {
        BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
        dbConfig.setTransactional(false);
        dbConfig.setAllowCreate(true);
        return dbConfig;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        try {
            this.queueDb.sync();
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        s.defaultWriteObject();
    }

    public void close() {
        try {
            this.queueDb.sync();
            this.queueDb.close();
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }
}

