/*
 * Decompiled with CFR 0.152.
 */
package org.archive.queue;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.archive.queue.StoredQueue;
import org.archive.settings.file.BdbModule;
import org.archive.util.FileUtils;
import org.archive.util.TmpDirTestCase;
import org.archive.util.bdbje.EnhancedEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredQueueTest
extends TmpDirTestCase {
    StoredQueue<String> queue;
    EnhancedEnvironment env;
    Database db;
    File envDir;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.envDir = new File(this.getTmpDir(), "StoredMapTest");
        this.envDir.mkdirs();
        try {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setTransactional(false);
            envConfig.setAllowCreate(true);
            this.env = new EnhancedEnvironment(this.envDir, envConfig);
            BdbModule.BdbConfig dbConfig = StoredQueue.databaseConfig();
            this.db = this.env.openDatabase(null, "StoredMapTest", dbConfig.toDatabaseConfig());
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        this.queue = new StoredQueue(this.db, String.class, this.env.getClassCatalog());
    }

    protected void tearDown() throws Exception {
        this.db.close();
        this.env.close();
        FileUtils.deleteDir(this.envDir);
        super.tearDown();
    }

    public void testAdd() {
        StoredQueueTest.assertEquals((String)"not empty at start", (int)0, (int)this.queue.size());
        this.fill(this.queue, 10);
        StoredQueueTest.assertEquals((String)"unexpected size at full", (int)10, (int)this.queue.size());
    }

    protected void fill(int size) {
        this.fill(this.queue, size);
    }

    protected void fill(Queue<String> q, int size) {
        for (int i = 1; i <= size; ++i) {
            q.add("item-" + i);
        }
    }

    protected int drain(Queue<String> q) {
        int count = 0;
        try {
            while (true) {
                q.remove();
                ++count;
            }
        }
        catch (NoSuchElementException nse) {
            return count;
        }
    }

    public void testClear() {
        this.fill(this.queue, 10);
        this.queue.clear();
        StoredQueueTest.assertEquals((String)"unexpected size after clear", (int)0, (int)this.queue.size());
    }

    public void testRemove() {
        this.fill(this.queue, 10);
        StoredQueueTest.assertEquals((String)"unexpected remove value", (String)"item-1", (String)((String)this.queue.remove()));
        StoredQueueTest.assertEquals((String)"improper count of removed items", (int)9, (int)this.drain(this.queue));
        try {
            this.queue.remove();
            StoredQueueTest.fail((String)"expected NoSuchElementException not received");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testOrdering() {
        this.fill(this.queue, 10);
        for (int i = 1; i <= 10; ++i) {
            StoredQueueTest.assertEquals((String)"unexpected remove value", (String)("item-" + i), (String)((String)this.queue.remove()));
        }
    }

    public void testElement() {
        this.fill(this.queue, 10);
        StoredQueueTest.assertEquals((String)"unexpected element value", (String)"item-1", (String)((String)this.queue.element()));
        StoredQueueTest.assertEquals((String)"unexpected element value", (String)((String)this.queue.peek()), (String)((String)this.queue.element()));
        this.queue.clear();
        try {
            this.queue.element();
            StoredQueueTest.fail((String)"expected NoSuchElementException not received");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void xestTimingsAgainstLinkedBlockingQueue() {
        this.tryTimings(50000);
        this.tryTimings(500000);
    }

    private void tryTimings(int i) {
        LinkedBlockingQueue<String> lbq = new LinkedBlockingQueue<String>();
        long start = System.currentTimeMillis();
        this.fill(lbq, i);
        this.drain(lbq);
        long finish = System.currentTimeMillis();
        System.out.println("LBQ - " + i + ":" + (finish - start));
        start = System.currentTimeMillis();
        this.fill(this.queue, i);
        this.drain(this.queue);
        finish = System.currentTimeMillis();
        System.out.println("SQ - " + i + ":" + (finish - start));
    }
}

