/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.archive.settings.CheckpointInputStream;
import org.archive.settings.CheckpointRecovery;
import org.archive.settings.RecoverAction;
import org.archive.settings.SheetManager;
import org.archive.settings.file.Checkpointable;
import org.archive.util.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checkpointer {
    public static final String ACTIONS_FILE = "actions.serialized";
    public static final String OBJECT_GRAPH_FILE = "object_graph.serialized";

    private Checkpointer() {
    }

    public static void checkpoint(SheetManager mgr, File dir) throws IOException {
        ArrayList<RecoverAction> actions = new ArrayList<RecoverAction>();
        for (Checkpointable c : mgr.getCheckpointables()) {
            c.checkpoint(dir, actions);
        }
        Checkpointer.writeObject(new File(dir, ACTIONS_FILE), actions);
        Checkpointer.writeObject(new File(dir, OBJECT_GRAPH_FILE), mgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeObject(File f, Object o) throws IOException {
        ObjectOutputStream oout = null;
        try {
            oout = new ObjectOutputStream(new FileOutputStream(f));
            oout.writeObject(o);
        }
        catch (Throwable throwable) {
            IoUtils.close(oout);
            throw throwable;
        }
        IoUtils.close(oout);
    }

    private static List<RecoverAction> readActions(File dir) throws IOException {
        List list;
        File actionsFile = new File(dir, ACTIONS_FILE);
        ObjectInputStream oinp = null;
        try {
            List actions;
            oinp = new ObjectInputStream(new FileInputStream(actionsFile));
            list = actions = (List)oinp.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                IOException io = new IOException();
                io.initCause(e);
                throw io;
            }
            catch (Throwable throwable) {
                IoUtils.close(oinp);
                throw throwable;
            }
        }
        IoUtils.close(oinp);
        return list;
    }

    public static SheetManager recover(File dir, CheckpointRecovery recovery) throws IOException {
        SheetManager sheetManager;
        List<RecoverAction> actions = Checkpointer.readActions(dir);
        for (RecoverAction action : actions) {
            try {
                action.recoverFrom(dir, recovery);
            }
            catch (Exception e) {
                IOException io = new IOException();
                io.initCause(e);
                throw io;
            }
        }
        CheckpointInputStream cinp = null;
        try {
            File f = new File(dir, OBJECT_GRAPH_FILE);
            cinp = new CheckpointInputStream(new FileInputStream(f), recovery);
            SheetManager mgr = (SheetManager)cinp.readObject();
            recovery.apply(mgr.getGlobalSheet());
            sheetManager = mgr;
        }
        catch (ClassNotFoundException e) {
            try {
                IOException io = new IOException();
                io.initCause(e);
                throw io;
            }
            catch (Throwable throwable) {
                IoUtils.close(cinp);
                throw throwable;
            }
        }
        IoUtils.close(cinp);
        return sheetManager;
    }
}

