/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.net.URI;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.archive.settings.CheckpointRecovery;
import org.archive.settings.SingleSheet;
import org.archive.state.Key;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCheckpointRecovery
implements CheckpointRecovery {
    private final Map<Object, Map<Key, Object>> newSettings = new IdentityHashMap<Object, Map<Key, Object>>();
    private final Map<URI, URI> uriTranslations = new HashMap<URI, URI>();
    private final Map<String, String> fileTranslations = new HashMap<String, String>();
    private final String name;

    public DefaultCheckpointRecovery(String name) {
        this.name = name;
    }

    @Override
    public String getRecoveredJobName() {
        return this.name;
    }

    public Map<String, String> getFileTranslations() {
        return this.fileTranslations;
    }

    public Map<URI, URI> getURITranslations() {
        return this.uriTranslations;
    }

    @Override
    public <T> void setState(Object module, Key<T> key, T value) {
        Map<Key, Object> map = this.newSettings.get(module);
        if (map == null) {
            map = new HashMap<Key, Object>();
            this.newSettings.put(module, map);
        }
        map.put(key, value);
    }

    @Override
    public String translatePath(String path) {
        Map.Entry<String, String> match = null;
        for (Map.Entry<String, String> me : this.fileTranslations.entrySet()) {
            if (!path.startsWith(me.getKey()) || match != null && ((String)match.getKey()).length() >= me.getKey().length()) continue;
            match = me;
        }
        if (match == null) {
            return path;
        }
        int size = ((String)match.getKey()).length();
        return (String)match.getValue() + path.substring(size);
    }

    @Override
    public URI translateURI(URI uri) {
        URI r = this.uriTranslations.get(uri);
        return r == null ? uri : r;
    }

    @Override
    public void apply(SingleSheet global) {
        for (Map.Entry<Object, Map<Key, Object>> mod : this.newSettings.entrySet()) {
            Object module = mod.getKey();
            for (Map.Entry<Key, Object> me : mod.getValue().entrySet()) {
                Key k = me.getKey();
                global.set(module, k, me.getValue());
            }
        }
    }
}

