/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.archive.settings.ModuleInfo;
import org.archive.settings.SettingsList;
import org.archive.settings.SettingsMap;
import org.archive.settings.Sheet;
import org.archive.settings.SingleSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Duplicator {
    private final IdentityHashMap<Object, Object> changes = new IdentityHashMap();
    private final SingleSheet oldSheet;
    private final SingleSheet newSheet;

    public Duplicator(SingleSheet oldSheet, SingleSheet newSheet) {
        this.oldSheet = oldSheet;
        this.newSheet = newSheet;
    }

    public SingleSheet getOldSheet() {
        return this.oldSheet;
    }

    public SingleSheet getNewSheet() {
        return this.newSheet;
    }

    public List<Sheet> duplicateSheets(List<Sheet> sheets) {
        ArrayList<Sheet> newSheets = new ArrayList<Sheet>();
        for (Sheet s : sheets) {
            if (s == this.oldSheet) {
                newSheets.add(this.newSheet);
                continue;
            }
            newSheets.add(s);
        }
        return newSheets;
    }

    public Object duplicate(Object o) {
        SettingsMap result = this.changes.get(o);
        if (result != null) {
            return result;
        }
        if (o instanceof SettingsList) {
            result = ((SettingsList)o).duplicate(this);
            this.changes.put(o, result);
        } else if (o instanceof SettingsMap) {
            result = ((SettingsMap)o).duplicate(this);
            this.changes.put(o, result);
        } else if (o instanceof ModuleInfo) {
            ModuleInfo oldInfo = (ModuleInfo)o;
            ModuleInfo newInfo = new ModuleInfo();
            newInfo.first = oldInfo.first;
            newInfo.holder = this.newSheet.holders.get(oldInfo.holder.module);
            result = newInfo;
        } else {
            result = o;
        }
        return result;
    }
}

