/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.archive.settings.ModuleListener;
import org.archive.settings.SheetManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListModuleListener<T>
implements ModuleListener,
Serializable {
    private static final Object PRESENT = "";
    private static final long serialVersionUID = 1L;
    private final Class<T> type;
    private transient Map<T, Object> objects = new WeakHashMap<T, Object>();

    public ListModuleListener(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null.");
        }
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moduleChanged(Object old, Object newModule) {
        if (newModule == null) {
            return;
        }
        if (!this.type.isAssignableFrom(newModule.getClass())) {
            return;
        }
        T t = this.type.cast(newModule);
        Map<T, Object> map = this.objects;
        synchronized (map) {
            this.objects.put(t, PRESENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getList() {
        Map<T, Object> map = this.objects;
        synchronized (map) {
            return new ArrayList<T>(this.objects.keySet());
        }
    }

    public static <T> ListModuleListener<T> make(Class<T> type) {
        return new ListModuleListener<T>(type);
    }

    public static <T> List<T> get(SheetManager mgr, Class<T> type) {
        for (ModuleListener l : mgr.getModuleListeners()) {
            ListModuleListener lml;
            if (!(l instanceof ListModuleListener) || !(lml = (ListModuleListener)l).getType().equals(type)) continue;
            List<T> result = lml.getList();
            return result;
        }
        return Collections.emptyList();
    }

    public Class<T> getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        HashMap<T, Object> temp = new HashMap<T, Object>(this.objects.size());
        Map<T, Object> map = this.objects;
        synchronized (map) {
            temp.putAll(this.objects);
        }
        out.writeObject(temp);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Map temp = (Map)in.readObject();
        this.objects = new WeakHashMap<T, Object>(temp);
    }
}

