/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.archive.settings.Association;
import org.archive.settings.SettingsMap;
import org.archive.settings.Sheet;
import org.archive.settings.SheetManager;
import org.archive.settings.SingleSheet;
import org.archive.settings.Stub;
import org.archive.settings.file.PrefixFinder;
import org.archive.settings.path.PathChangeException;
import org.archive.state.DefaultPathContext;
import org.archive.state.KeyManager;
import org.archive.state.PathContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemorySheetManager
extends SheetManager {
    private static final long serialVersionUID = 1L;
    private final Map<String, Sheet> sheets;
    private final SortedMap<String, Set<Sheet>> associations;
    private final PathContext pathContext = new DefaultPathContext(new File("."));

    public MemorySheetManager() {
        this(true);
    }

    public MemorySheetManager(boolean live) {
        super("unkownn", live);
        this.sheets = new HashMap<String, Sheet>();
        this.sheets.put("default", this.getUnspecifiedSheet());
        this.associations = new TreeMap<String, Set<Sheet>>();
        SingleSheet globals = this.addSingleSheet("global");
        if (live) {
            globals.set(this, MANAGER, this);
        } else {
            Stub stub = (Stub)this.getManagerModule();
            globals.setStub(stub, MANAGER, stub);
        }
        globals.set(this.getManagerModule(), ROOT, new SettingsMap<Object>(globals, Object.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getSheetNames() {
        Map<String, Sheet> map = this.sheets;
        synchronized (map) {
            return new HashSet<String>(this.sheets.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SingleSheet addSingleSheet(String name) {
        Map<String, Sheet> map = this.sheets;
        synchronized (map) {
            Sheet old = this.sheets.get(name);
            if (old != null) {
                throw new IllegalArgumentException("Sheet already exists: " + name);
            }
            SingleSheet r = name.equals("global") ? this.createSingleSheet(null, name) : this.createSingleSheet(this.getGlobalSheet(), name);
            this.sheets.put(name, r);
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameSheet(String oldName, String newName) {
        Map<String, Sheet> map = this.sheets;
        synchronized (map) {
            Sheet sheet = this.sheets.remove(oldName);
            if (sheet == null) {
                throw new IllegalArgumentException("No such sheet: " + oldName);
            }
            this.sheets.put(newName, sheet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sheet getSheet(String name) {
        Map<String, Sheet> map = this.sheets;
        synchronized (map) {
            Sheet sheet = this.sheets.get(name);
            if (sheet == null) {
                throw new IllegalArgumentException("No such sheet: " + name);
            }
            return sheet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSheet(String name) {
        Sheet sheet;
        Map<String, Sheet> map = this.sheets;
        synchronized (map) {
            sheet = this.sheets.remove(name);
            if (sheet == null) {
                throw new IllegalArgumentException("No such sheet: " + name);
            }
        }
        Set<Sheet> s = Collections.singleton(sheet);
        this.associations.values().removeAll(s);
    }

    @Override
    public Collection<String> getAssociations(String context) {
        HashSet<String> result = new HashSet<String>();
        Set sheets = (Set)this.associations.get(context);
        for (Sheet sheet : sheets) {
            result.add(sheet.getName());
        }
        return result;
    }

    @Override
    public Set<String> getContexts() {
        return this.associations.keySet();
    }

    @Override
    public void associate(Sheet sheet, Collection<String> surts) {
        for (String surt : surts) {
            HashSet<Sheet> sheets = (HashSet<Sheet>)this.associations.get(surt);
            if (sheets == null) {
                sheets = new HashSet<Sheet>();
                this.associations.put(surt, sheets);
            }
            sheets.add(sheet);
        }
    }

    @Override
    public void disassociate(Sheet sheet, Collection<String> surts) {
        for (String surt : surts) {
            Set sheets = (Set)this.associations.get(surt);
            if (sheets == null) continue;
            sheets.remove(sheet);
            if (!sheets.isEmpty()) continue;
            this.associations.remove(surt);
        }
    }

    public File getDirectory() {
        return new File(".");
    }

    @Override
    public void commit(Sheet sheet) {
        if (sheet.getSheetManager() != this) {
            throw new IllegalArgumentException();
        }
        if (!sheet.isClone()) {
            throw new IllegalArgumentException();
        }
        this.clearCloneFlag(sheet);
        this.sheets.put(sheet.getName(), sheet);
        this.announceChanges(sheet);
    }

    @Override
    public Set<String> getProblemSingleSheetNames() {
        return Collections.emptySet();
    }

    @Override
    public List<PathChangeException> getSingleSheetProblems(String sheet) {
        return Collections.emptyList();
    }

    @Override
    public List<Association> findConfigNames(String uri) {
        ArrayList<Association> result = new ArrayList<Association>();
        ArrayList<String> prefixes = new ArrayList<String>();
        PrefixFinder.find((SortedSet)this.associations.keySet(), uri, prefixes);
        for (String prefix : prefixes) {
            Set sheets = (Set)this.associations.get(prefix);
            for (Sheet sheet : sheets) {
                result.add(new Association(prefix, sheet.getName()));
            }
        }
        return result;
    }

    @Override
    public Sheet findConfig(String context) {
        ArrayList<Sheet> result = new ArrayList<Sheet>();
        ArrayList<String> prefixes = new ArrayList<String>();
        TreeSet<String> k = new TreeSet<String>(this.associations.keySet());
        PrefixFinder.find(k, context, prefixes);
        for (String prefix : prefixes) {
            Set sheets = (Set)this.associations.get(prefix);
            for (Sheet sheet : sheets) {
                result.add(sheet);
            }
        }
        if (result.isEmpty()) {
            return this.getGlobalSheet();
        }
        if (result.size() == 1) {
            return (Sheet)result.get(0);
        }
        return this.createSheetBundle("anonymous", result);
    }

    @Override
    public Collection<String> listContexts(String sheetName, int ofs, int len) {
        int count = 0;
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Set<Sheet>> me : this.associations.entrySet()) {
            for (Sheet sheet : me.getValue()) {
                if (!sheet.getName().equals(sheetName)) continue;
                if (count >= ofs) {
                    result.add(me.getKey());
                    if (result.size() >= len) {
                        return result;
                    }
                }
                ++count;
            }
        }
        return result;
    }

    @Override
    public void stubCleanup() {
    }

    @Override
    public PathContext getPathContext() {
        return this.pathContext;
    }

    static {
        KeyManager.addKeys(MemorySheetManager.class);
    }
}

