/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.archive.settings.Sheet;
import org.archive.settings.TypedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiTypedList<T>
extends AbstractList<T>
implements TypedList<T> {
    private final List<TypedList<T>> lists;
    private final Sheet start;
    private int size = -1;

    public MultiTypedList(List<TypedList<T>> lists, Sheet start) {
        this.lists = lists;
        this.start = start;
    }

    @Override
    public int size() {
        if (this.size != -1) {
            return this.size;
        }
        int sz = 0;
        for (TypedList<T> list : this.lists) {
            sz += list.size();
        }
        return sz;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public T get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int lower = 0;
        for (TypedList<T> list : this.lists) {
            int sz = list.size();
            if (index < lower + sz) {
                return (T)list.get(index - lower);
            }
            lower += sz;
        }
        this.size = lower;
        throw new IndexOutOfBoundsException(index + " >= " + lower);
    }

    @Override
    public List<Sheet> getSheets(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        ArrayList<Sheet> result = new ArrayList<Sheet>();
        if (this.start != null) {
            result.add(this.start);
        }
        int lower = 0;
        for (TypedList<T> list : this.lists) {
            int sz = list.size();
            if (index < lower + sz) {
                result.addAll(list.getSheets(index - lower));
                return result;
            }
            lower += sz;
        }
        this.size = lower;
        throw new IndexOutOfBoundsException(index + " >= " + lower);
    }

    @Override
    public Class<T> getElementType() {
        return this.lists.get(0).getElementType();
    }
}

