/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.archive.settings.Sheet;
import org.archive.settings.TypedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiTypedMap<T>
extends AbstractMap<String, T>
implements TypedMap<T> {
    private List<TypedMap<T>> maps;
    private Set<Map.Entry<String, T>> entrySet;
    private Sheet start;

    public MultiTypedMap(List<TypedMap<T>> maps, Sheet start) {
        this.maps = maps;
        this.start = start;
    }

    @Override
    public T get(Object object) {
        for (TypedMap<T> map : this.maps) {
            Object result = map.get(object);
            if (result == null) continue;
            return (T)result;
        }
        return null;
    }

    @Override
    public List<Sheet> getSheets(String key) {
        ArrayList<Sheet> result = new ArrayList<Sheet>();
        if (this.start != null) {
            result.add(this.start);
        }
        for (TypedMap<T> map : this.maps) {
            if (map.get(key) == null) continue;
            List<Sheet> s = map.getSheets(key);
            result.addAll(s);
            return result;
        }
        return result;
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        if (this.maps.size() == 1) {
            return this.maps.get(0).entrySet();
        }
        if (this.entrySet == null) {
            LinkedHashMap entries = new LinkedHashMap();
            for (int i = this.maps.size() - 1; i >= 0; --i) {
                Map map = this.maps.get(i);
                entries.putAll(map);
            }
            this.entrySet = Collections.unmodifiableSet(entries.entrySet());
        }
        return this.entrySet;
    }

    @Override
    public Class<T> getElementType() {
        return this.maps.get(0).getElementType();
    }
}

