/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.archive.settings.Sheet;
import org.archive.settings.Stub;
import org.archive.settings.TypedList;
import org.archive.settings.TypedMap;
import org.archive.settings.UnmodifiableTypedMap;
import org.archive.state.Key;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolved<T> {
    private Key<T> key;
    private Object module;
    private Object value;
    private List<Sheet> sheets;

    private Resolved(Object module, Key<T> key, Object value, List<Sheet> sheets) {
        this.key = key;
        this.module = module;
        this.value = value;
        this.sheets = sheets;
    }

    public Stub<?> getStubValue() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof Stub)) {
            throw new IllegalStateException("Live or leaf sheet.");
        }
        return (Stub)this.value;
    }

    public Key<T> getKey() {
        return this.key;
    }

    public Object getModule() {
        return this.module;
    }

    public List<Sheet> getSheets() {
        return this.sheets;
    }

    public Sheet getLastSheet() {
        List<Sheet> sheets = this.getSheets();
        return sheets.get(sheets.size() - 1);
    }

    public T getLiveValue() {
        if (this.value instanceof Stub) {
            throw new IllegalStateException("Not an live/leaf sheet.");
        }
        Object r = this.value;
        return (T)r;
    }

    public Object getValue() {
        if (this.getLastSheet().isLive(this.key)) {
            return this.getLiveValue();
        }
        return this.getStubValue();
    }

    public static <T> Resolved<T> makeLive(Object module, Key<T> key, T value, List<Sheet> sheets) {
        sheets = new ArrayList<Sheet>(sheets);
        sheets = Collections.unmodifiableList(sheets);
        return new Resolved<T>(module, key, value, sheets);
    }

    static <T> Resolved<T> make(Object module, Key<T> key, Object value, List<Sheet> sheets) {
        return new Resolved<T>(module, key, value, sheets);
    }

    public static <T> Resolved<T> makeLive(Object module, Key<T> key, T value, Sheet sheet) {
        List<Sheet> l = Collections.singletonList(sheet);
        return Resolved.make(module, key, value, l);
    }

    public static <T> Resolved<T> makeStub(Object module, Key<T> key, Stub stub, List<Sheet> sheets) {
        List<Sheet> l = new ArrayList<Sheet>(sheets);
        l = Collections.unmodifiableList(l);
        return Resolved.make(module, key, stub, sheets);
    }

    public static <T> Resolved<T> makeStub(Object module, Key<T> key, Stub stub, Sheet sheet) {
        List<Sheet> l = Collections.singletonList(sheet);
        return Resolved.makeStub(module, key, stub, l);
    }

    public static <T> Resolved<T> makeMap(Object module, Key<T> key, TypedMap<Object> value, List<Sheet> sheets) {
        value = new UnmodifiableTypedMap<Object>(value);
        return Resolved.make(module, key, value, sheets);
    }

    public static <T> Resolved<T> makeList(Object module, Key<T> key, TypedList<Object> value, List<Sheet> sheets) {
        return Resolved.make(module, key, value, sheets);
    }

    public static <T> Resolved<T> makeList(Object module, Key<T> key, T value, List<Sheet> sheets) {
        return Resolved.make(module, key, value, sheets);
    }
}

