/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.archive.settings.Duplicator;
import org.archive.settings.ListContainer;
import org.archive.settings.ModuleInfo;
import org.archive.settings.Sheet;
import org.archive.settings.SheetManager;
import org.archive.settings.SingleSheet;
import org.archive.settings.TypedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsList<T>
extends AbstractList<T>
implements TypedList<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Object> delegate;
    private final SingleSheet sheet;
    private final List<Sheet> sheets;
    private final SheetManager manager;
    private final Class<T> elementType;

    public SettingsList(SingleSheet sheet, Class<T> c) {
        this(sheet, new ArrayList(), c);
    }

    public SettingsList(SingleSheet sheet, List<T> list, Class<T> c) {
        List<T> l = list;
        this.delegate = new ArrayList<T>(l);
        this.sheet = sheet;
        this.sheets = Collections.unmodifiableList(Collections.singletonList(sheet));
        this.manager = sheet.getSheetManager();
        this.elementType = c;
    }

    Object duplicate(Duplicator d) {
        ArrayList<Object> newElements = new ArrayList<Object>();
        for (Object e : this.delegate) {
            newElements.add(d.duplicate(e));
        }
        return new SettingsList(d.getNewSheet(), newElements, this.elementType);
    }

    @Override
    public List<Sheet> getSheets(int index) {
        return this.sheets;
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    private void validate(T element) {
        String s;
        if (element instanceof String && ((s = (String)element).indexOf(10) >= 0 || s.indexOf(13) >= 0)) {
            throw new IllegalArgumentException("List elements cannot contain a newline.");
        }
        ++this.modCount;
    }

    @Override
    public void add(int index, T element) {
        this.validate(element);
        if (!SingleSheet.isModuleType(this.elementType)) {
            this.delegate.add(index, element);
        } else {
            this.setModuleValue(index, element);
        }
    }

    @Override
    public boolean add(T o) {
        this.validate(o);
        if (!SingleSheet.isModuleType(this.elementType)) {
            this.delegate.add(o);
        } else {
            this.setModuleValue(this.size(), o);
        }
        return true;
    }

    @Override
    public void clear() {
        for (Object t : this.delegate) {
            this.manager.fireModuleChanged(t, null);
        }
        this.delegate.clear();
    }

    private T toActualObject(Object in) {
        if (in instanceof ModuleInfo) {
            in = ((ModuleInfo)in).holder.module;
        }
        return (T)in;
    }

    @Override
    public T get(int index) {
        return this.toActualObject(this.delegate.get(index));
    }

    @Override
    public T remove(int index) {
        T result = this.toActualObject(this.delegate.remove(index));
        this.manager.fireModuleChanged(result, null);
        return result;
    }

    @Override
    public T set(int index, T element) {
        this.validate(element);
        Object old = !SingleSheet.isModuleType(this.elementType) ? this.delegate.set(index, element) : this.setModuleValue(index, element);
        return (T)old;
    }

    private Object setModuleValue(int i, Object value) {
        ListContainer c = new ListContainer(this.delegate);
        Object old = this.sheet.setModuleValue(c, i, value);
        this.manager.fireModuleChanged(old, value);
        return old;
    }

    public void swap(int index1, int index2) {
        Object o1 = this.delegate.get(index1);
        Object o2 = this.delegate.set(index2, o1);
        this.delegate.set(index1, o2);
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }
}

