/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.archive.settings.Duplicator;
import org.archive.settings.MapContainer;
import org.archive.settings.ModuleInfo;
import org.archive.settings.Sheet;
import org.archive.settings.SheetManager;
import org.archive.settings.SingleSheet;
import org.archive.settings.TypedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsMap<T>
implements TypedMap<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> delegate;
    private final SheetManager manager;
    private final List<Sheet> sheets;
    private final SingleSheet sheet;
    private final Class<T> elementType;

    public SettingsMap(SingleSheet sheet, Class<T> c) {
        this(sheet, new LinkedHashMap(), c);
    }

    public SettingsMap(SingleSheet sheet, Map<String, T> map, Class<T> c) {
        this.delegate = SettingsMap.cast(map);
        this.sheet = sheet;
        this.sheets = Collections.singletonList(sheet);
        this.manager = sheet.getSheetManager();
        this.elementType = c;
    }

    public SettingsMap<T> duplicate(Duplicator d) {
        LinkedHashMap<String, Object> newDelegate = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> me : this.delegate.entrySet()) {
            newDelegate.put(me.getKey(), d.duplicate(me.getValue()));
        }
        return new SettingsMap(d.getNewSheet(), newDelegate, this.elementType);
    }

    private T toActualObject(Object x) {
        if (x instanceof ModuleInfo) {
            x = ((ModuleInfo)x).holder.module;
        }
        return (T)x;
    }

    @Override
    public List<Sheet> getSheets(String key) {
        return this.sheets;
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    @Override
    public void clear() {
        Iterator<Object> iter = this.delegate.values().iterator();
        while (iter.hasNext()) {
            T old = this.toActualObject(iter.next());
            iter.remove();
            this.manager.fireModuleChanged(old, null);
        }
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return new EntrySet(this.delegate.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map map = (Map)o;
        return ((Object)this.entrySet()).equals(map.entrySet());
    }

    @Override
    public T get(Object key) {
        return this.toActualObject(this.delegate.get(key));
    }

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        Set<Map.Entry<String, Object>> set = this.delegate.entrySet();
        return new KeySet(set);
    }

    private void validate(String key, Object value) {
        String s;
        if (key.indexOf(58) >= 0) {
            throw new IllegalArgumentException("Keys cannot contain a colon.");
        }
        if (key.indexOf(10) >= 0 || key.indexOf(13) >= 0) {
            throw new IllegalArgumentException("Keys cannot contain a newline.");
        }
        if (value instanceof String && ((s = (String)value).indexOf(10) >= 0 || s.indexOf(13) >= 0)) {
            throw new IllegalArgumentException("Values cannot contain a newline.");
        }
    }

    @Override
    public T put(String key, T value) {
        this.validate(key, value);
        if (!SingleSheet.isModuleType(this.elementType)) {
            Object oldObj = this.delegate.put(key, value);
            T old = this.elementType.cast(oldObj);
            this.manager.fireModuleChanged(old, value);
            return old;
        }
        MapContainer container = new MapContainer(this.delegate);
        Object old = this.sheet.setModuleValue(container, key, value);
        this.manager.fireModuleChanged(old, value);
        return (T)old;
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> t) {
        for (Map.Entry<String, T> me : t.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public T remove(Object key) {
        T old = this.toActualObject(this.delegate.remove(key));
        this.manager.fireModuleChanged(old, null);
        return old;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Collection<T> values() {
        Collection<Object> values = this.delegate.values();
        return new Values(values);
    }

    public void moveElement(String key, boolean up) {
        ArrayList<Map.Entry<String, Object>> arr = new ArrayList<Map.Entry<String, Object>>(this.delegate.entrySet());
        int index = -1;
        for (int i = 0; i < arr.size(); ++i) {
            Map.Entry<String, Object> me = arr.get(i);
            if (!me.getKey().equals(key)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("No such key: " + key);
        }
        int index2 = up ? index - 1 : index + 1;
        Collections.swap(arr, index, index2);
        this.delegate.clear();
        for (Map.Entry<String, Object> me : arr) {
            this.delegate.put(me.getKey(), me.getValue());
        }
    }

    private static Map<String, Object> cast(Map<String, ?> map) {
        Map<String, Object> m = map;
        return m;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    implements Iterator<T> {
        final Iterator<Object> iter;
        T last;

        public ValueIterator(Iterator<Object> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            this.last = SettingsMap.this.toActualObject(this.iter.next());
            return this.last;
        }

        @Override
        public void remove() {
            SettingsMap.this.manager.fireModuleChanged(this.last, null);
            this.iter.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<String, T>> {
        Iterator<Map.Entry<String, Object>> iter;
        T last;

        public EntryIterator(Iterator<Map.Entry<String, Object>> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<String, T> next() {
            Map.Entry<String, Object> me = this.iter.next();
            this.last = SettingsMap.this.toActualObject(me.getValue());
            DefaultMapEntry result = new DefaultMapEntry((Object)me.getKey(), this.last);
            return result;
        }

        @Override
        public void remove() {
            SettingsMap.this.manager.fireModuleChanged(this.last, null);
            this.iter.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    implements Iterator<String> {
        final Iterator<Map.Entry<String, Object>> iter;
        T last;

        public KeyIterator(Iterator<Map.Entry<String, Object>> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public String next() {
            Map.Entry<String, Object> me = this.iter.next();
            this.last = SettingsMap.this.toActualObject(me.getValue());
            return me.getKey();
        }

        @Override
        public void remove() {
            SettingsMap.this.manager.fireModuleChanged(this.last, null);
            this.iter.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<T> {
        private Collection<Object> set;

        public Values(Collection<Object> set) {
            this.set = set;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Iterator<T> iterator() {
            return new ValueIterator(this.set.iterator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<String, T>> {
        private Set<Map.Entry<String, Object>> set;

        public EntrySet(Set<Map.Entry<String, Object>> set) {
            this.set = set;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Iterator<Map.Entry<String, T>> iterator() {
            return new EntryIterator(this.set.iterator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<String> {
        private Set<Map.Entry<String, Object>> set;

        public KeySet(Set<Map.Entry<String, Object>> set) {
            this.set = set;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator(this.set.iterator());
        }
    }
}

