/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.archive.settings.Resolved;
import org.archive.settings.SheetManager;
import org.archive.settings.SingleSheet;
import org.archive.settings.Stub;
import org.archive.state.Key;
import org.archive.state.KeyTypes;
import org.archive.state.StateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Sheet
implements StateProvider,
Serializable {
    private final SheetManager manager;
    final String parentName;
    private String name;
    private boolean clone;

    Sheet(SheetManager manager, String parentName, String name) {
        if (manager == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.parentName = parentName;
        this.manager = manager;
    }

    public SheetManager getSheetManager() {
        return this.manager;
    }

    public Sheet getParent() {
        if (this.parentName == null) {
            return null;
        }
        return this.manager.getSheet(this.parentName);
    }

    public String getName() {
        return this.name;
    }

    public boolean isClone() {
        return this.clone;
    }

    void setClone(boolean clone) {
        this.clone = clone;
    }

    public abstract boolean contains(Object var1, Key<?> var2);

    abstract Object check(Object var1, Key<?> var2);

    public abstract <T> Resolved<T> resolve(Object var1, Key<T> var2);

    @Override
    public <T> T get(Object module, Key<T> key) {
        return this.resolve(module, key).getLiveValue();
    }

    boolean isLive(Key key) {
        return this.isLive(key.getType());
    }

    boolean isLive(Class type) {
        if (this.getSheetManager().isLive()) {
            return true;
        }
        if (type == List.class) {
            return true;
        }
        if (type == Map.class) {
            return true;
        }
        return KeyTypes.isSimple(type);
    }

    public String toString() {
        return this.name;
    }

    abstract Sheet duplicate();

    static <T> void validateModuleType(Object module, Key<T> key) {
        Class mtype = Stub.getType(module);
        if (!key.getOwner().isAssignableFrom(mtype)) {
            throw new IllegalArgumentException("Illegal module type.  Key owner is " + key.getOwner().getName() + " but module is " + mtype.getName());
        }
    }

    SingleSheet getGlobalSheet() {
        return this.getSheetManager().getGlobalSheet();
    }
}

