/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.archive.settings.MultiTypedList;
import org.archive.settings.MultiTypedMap;
import org.archive.settings.Resolved;
import org.archive.settings.Sheet;
import org.archive.settings.SheetManager;
import org.archive.settings.SingleSheet;
import org.archive.settings.TypedList;
import org.archive.settings.TypedMap;
import org.archive.settings.UnspecifiedSheet;
import org.archive.state.Key;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SheetBundle
extends Sheet {
    private static final long serialVersionUID = 1L;
    private final List<Sheet> sheets;
    private final List<Sheet> sheetsInListOrder;
    private final List<Sheet> sheetsInMapOrder;

    SheetBundle(SheetManager manager, String name, Collection<Sheet> sheets) {
        super(manager, null, name);
        this.sheets = Collections.unmodifiableList(new ArrayList<Sheet>(sheets));
        this.sheetsInListOrder = this.orderSheetsForListElements(this.sheets);
        this.sheetsInMapOrder = this.orderSheetsForMapElements(this.sheets);
    }

    private void addParentsForListElements(Map<Sheet, Object> map, Sheet sheet) {
        if (sheet instanceof UnspecifiedSheet) {
            return;
        }
        this.addParentsForListElements(map, sheet.getParent());
        map.put(sheet, null);
    }

    private List<Sheet> orderSheetsForListElements(List<Sheet> orig) {
        LinkedHashMap<Sheet, Object> result = new LinkedHashMap<Sheet, Object>();
        for (Sheet sheet : orig) {
            this.addParentsForListElements(result, sheet);
        }
        return Collections.unmodifiableList(new ArrayList(result.keySet()));
    }

    private void addParentsForMapElements(List<Sheet> list, Sheet sheet) {
        if (sheet.getName().equals("global")) {
            if (!list.contains(sheet)) {
                list.add(sheet);
            }
            return;
        }
        Sheet parent = sheet.getParent();
        this.addParentsForMapElements(list, parent);
        int i = list.indexOf(parent);
        list.add(i, sheet);
    }

    private List<Sheet> orderSheetsForMapElements(List<Sheet> orig) {
        ArrayList<Sheet> result = new ArrayList<Sheet>();
        for (Sheet sheet : orig) {
            this.addParentsForMapElements(result, sheet);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    SheetBundle duplicate() {
        return new SheetBundle(this.getSheetManager(), this.getName(), new CopyOnWriteArrayList<Sheet>(this.sheets));
    }

    @Override
    public boolean contains(Object module, Key<?> key) {
        for (Sheet sheet : this.sheets) {
            if (!sheet.contains(module, key)) continue;
            return true;
        }
        return false;
    }

    @Override
    Object check(Object module, Key<?> key) {
        Iterator<Sheet> i$ = this.sheets.iterator();
        if (i$.hasNext()) {
            Sheet sheet = i$.next();
            if (sheet.contains(module, key)) {
                return sheet.check(module, key);
            }
            Object result = sheet.check(module, key);
            return result;
        }
        return null;
    }

    @Override
    public <T> Resolved<T> resolve(Object module, Key<T> key) {
        if (Map.class.isAssignableFrom(key.getType())) {
            return this.resolveMap(module, key);
        }
        if (List.class.isAssignableFrom(key.getType())) {
            return this.resolveList(module, key);
        }
        return this.resolveNormal(module, key);
    }

    private <T> Resolved<T> resolveMap(Object module, Key<T> k) {
        Key<T> key = k;
        ArrayList list = new ArrayList();
        ArrayList<Sheet> definer = null;
        for (Sheet sheet : this.sheetsInMapOrder) {
            Resolved<T> r;
            TypedMap map;
            if (sheet instanceof SingleSheet) {
                map = (TypedMap)sheet.check(module, key);
                if (map == null) continue;
                list.add(map);
                if (definer != null) continue;
                definer = new ArrayList<Sheet>(2);
                definer.add(this);
                definer.add(sheet);
                continue;
            }
            if (!(sheet instanceof SheetBundle) || (map = (TypedMap)(r = sheet.resolve(module, key)).getValue()) == null) continue;
            list.add(map);
            if (definer != null) continue;
            definer = new ArrayList();
            definer.add(this);
            definer.addAll(r.getSheets());
        }
        if (list.isEmpty()) {
            return this.getGlobalSheet().resolve(module, k);
        }
        TypedMap tm = (TypedMap)this.getGlobalSheet().check(module, key);
        if (tm != null) {
            list.add(tm);
        }
        MultiTypedMap<Object> result = list.size() == 1 ? (MultiTypedMap<Object>)list.get(0) : new MultiTypedMap<Object>(list, this);
        return Resolved.makeMap(module, k, result, definer);
    }

    private <T> Resolved<T> resolveList(Object module, Key<T> k) {
        Key<T> key = k;
        ArrayList lists = new ArrayList();
        ArrayList<Sheet> definer = null;
        for (Sheet sheet : this.sheetsInListOrder) {
            Resolved<T> r;
            TypedList list;
            if (sheet instanceof SingleSheet) {
                list = (TypedList)sheet.check(module, key);
                if (list == null) continue;
                lists.add(list);
                if (definer != null) continue;
                definer = new ArrayList<Sheet>(2);
                definer.add(this);
                definer.add(sheet);
                continue;
            }
            if (!(sheet instanceof SheetBundle) || (list = (TypedList)(r = sheet.resolve(module, key)).getValue()) == null) continue;
            lists.add(list);
            if (definer != null) continue;
            definer = new ArrayList();
            definer.add(this);
            definer.addAll(r.getSheets());
        }
        if (lists.isEmpty()) {
            return this.getSheetManager().getUnspecifiedSheet().resolve(module, k);
        }
        MultiTypedList result = lists.size() == 1 ? (MultiTypedList)lists.get(0) : new MultiTypedList(lists, this);
        return Resolved.makeList(module, k, result, definer);
    }

    private <T> Resolved<T> resolveNormal(Object module, Key<T> key) {
        for (Sheet sheet : this.sheetsInMapOrder) {
            if (!sheet.contains(module, key)) continue;
            return sheet.resolve(module, key);
        }
        return this.getSheetManager().getUnspecifiedSheet().resolve(module, key);
    }

    public List<Sheet> getSheets() {
        return this.sheets;
    }
}

