/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.settings.Association;
import org.archive.settings.Finishable;
import org.archive.settings.Holder;
import org.archive.settings.KeyChangeEvent;
import org.archive.settings.KeyChangeListener;
import org.archive.settings.ListModuleListener;
import org.archive.settings.ModuleListener;
import org.archive.settings.Sheet;
import org.archive.settings.SheetBundle;
import org.archive.settings.SingleSheet;
import org.archive.settings.Stub;
import org.archive.settings.UnspecifiedSheet;
import org.archive.settings.file.Checkpointable;
import org.archive.settings.path.PathChangeException;
import org.archive.settings.path.PathListConsumer;
import org.archive.settings.path.PathLister;
import org.archive.state.Immutable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.PathContext;
import org.archive.state.StateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SheetManager
implements StateProvider,
Serializable {
    public static final Logger LOGGER = Logger.getLogger(SheetManager.class.getName());
    public static final String GLOBAL_SHEET_NAME = "global";
    public static final String DEFAULT_SHEET_NAME = "default";
    private final UnspecifiedSheet unspecified;
    private final transient Stub<?> stubThis;
    private List<ModuleListener> moduleListeners = new CopyOnWriteArrayList<ModuleListener>();
    private ListModuleListener<Finishable> finishables = ListModuleListener.make(Finishable.class);
    private ListModuleListener<Checkpointable> checkpointables = ListModuleListener.make(Checkpointable.class);
    private ListModuleListener<Closeable> closeables = ListModuleListener.make(Closeable.class);
    private boolean live;
    @Immutable
    public static final Key<Map<String, Object>> ROOT = Key.makeMap(Object.class);
    @Immutable
    public static final Key<SheetManager> MANAGER = Key.make(SheetManager.class, null);
    private String jobName;

    public SheetManager(String jobName, boolean live) {
        this.jobName = jobName;
        this.live = live;
        this.unspecified = new UnspecifiedSheet(this, DEFAULT_SHEET_NAME);
        this.stubThis = Stub.make(this.getClass());
        this.moduleListeners.add(this.checkpointables);
        this.moduleListeners.add(this.closeables);
        this.moduleListeners.add(this.finishables);
    }

    public List<Checkpointable> getCheckpointables() {
        return this.checkpointables.getList();
    }

    public List<Closeable> getCloseables() {
        return this.closeables.getList();
    }

    public List<Finishable> getFinishables() {
        return this.finishables.getList();
    }

    public SheetManager(String jobName, Collection<ModuleListener> listeners, boolean live) {
        this(jobName, live);
        this.moduleListeners.addAll(listeners);
    }

    public Sheet getUnspecifiedSheet() {
        return this.unspecified;
    }

    public Object getManagerModule() {
        if (this.isLive()) {
            return this;
        }
        return this.stubThis;
    }

    public SingleSheet getGlobalSheet() {
        return (SingleSheet)this.getSheet(GLOBAL_SHEET_NAME);
    }

    public Map<String, Object> getRoot() {
        return this.getGlobalSheet().resolveEditableMap(this.getManagerModule(), ROOT);
    }

    public abstract Set<String> getSheetNames();

    public abstract SingleSheet addSingleSheet(String var1);

    public abstract Sheet getSheet(String var1) throws IllegalArgumentException;

    protected final SingleSheet createSingleSheet(SingleSheet parent, String name) throws IllegalArgumentException {
        boolean global = name.equals(GLOBAL_SHEET_NAME);
        String parentName = global ? DEFAULT_SHEET_NAME : parent.getName();
        SingleSheet result = new SingleSheet(this, parentName, name, global);
        return result;
    }

    protected final SheetBundle createSheetBundle(String name, Collection<Sheet> c) throws IllegalArgumentException {
        SheetBundle result = new SheetBundle(this, name, c);
        return result;
    }

    public abstract void removeSheet(String var1) throws IllegalArgumentException;

    public abstract void renameSheet(String var1, String var2);

    public abstract void associate(Sheet var1, Collection<String> var2);

    public abstract void disassociate(Sheet var1, Collection<String> var2);

    public abstract Collection<String> getAssociations(String var1);

    public abstract Set<String> getContexts();

    public void cleanup() {
    }

    public String getCrawlName() {
        return this.jobName;
    }

    public final boolean isLive() {
        return this.live;
    }

    @Override
    public <T> T get(Object module, Key<T> key) {
        SingleSheet def = this.getGlobalSheet();
        return def.get(module, key);
    }

    public void addModuleListener(ModuleListener listener) {
        this.moduleListeners.add(listener);
    }

    public void removeModuleListener(ModuleListener listener) {
        this.moduleListeners.remove(listener);
    }

    public List<ModuleListener> getModuleListeners() {
        return new ArrayList<ModuleListener>(this.moduleListeners);
    }

    void fireModuleChanged(Object oldModule, Object newModule) {
        for (ModuleListener ml : this.moduleListeners) {
            try {
                ml.moduleChanged(oldModule, newModule);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "ModuleListener raised exception.", e);
            }
        }
    }

    public abstract Sheet findConfig(String var1);

    public abstract List<Association> findConfigNames(String var1);

    public void closeModules() {
        List<Finishable> finishables = this.getFinishables();
        for (Finishable f : finishables) {
            try {
                f.finalTasks(this);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not finish " + f, e);
            }
        }
        List<Closeable> closeables = this.getCloseables();
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not close " + c, e);
            }
        }
    }

    public Sheet checkout(String name) {
        Sheet s = this.getSheet(name);
        s = s.duplicate();
        s.setClone(true);
        return s;
    }

    protected void clearCloneFlag(Sheet sheet) {
        sheet.setClone(false);
    }

    protected void announceChanges(Sheet sheet) {
        if (sheet instanceof SingleSheet) {
            SingleSheet ss = (SingleSheet)sheet;
            List<KeyChangeEvent> list = ss.clearKeyChangeEvents();
            for (KeyChangeEvent event : list) {
                KeyChangeListener listener = (KeyChangeListener)event.getSource();
                try {
                    listener.keyChanged(event);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Exception during property change " + event, e);
                }
            }
        }
    }

    public abstract void commit(Sheet var1);

    public abstract Set<String> getProblemSingleSheetNames();

    public abstract List<PathChangeException> getSingleSheetProblems(String var1);

    public abstract Collection<String> listContexts(String var1, int var2, int var3);

    public abstract void stubCleanup();

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.live);
        out.writeObject(this.moduleListeners);
        out.writeObject(this.checkpointables);
        out.writeObject(this.closeables);
        out.writeObject(this.finishables);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.live = in.readBoolean();
        this.moduleListeners = (List)in.readObject();
        this.checkpointables = (ListModuleListener)in.readObject();
        this.closeables = (ListModuleListener)in.readObject();
        this.finishables = (ListModuleListener)in.readObject();
    }

    public abstract PathContext getPathContext();

    public <T> T findUniqueGlobalModule(final Class<T> cls) {
        final Holder result = new Holder();
        PathListConsumer consumer = new PathListConsumer(){
            List<String> paths = new ArrayList<String>();

            @Override
            public void consume(String path, List<Sheet> sheet, Object value, Class type, String seenPath) {
                if (cls.isInstance(value)) {
                    if (result.module == null) {
                        this.paths.add(path);
                        result.module = value;
                    } else if (result.module != value) {
                        this.paths.add(path);
                        throw new IllegalStateException("Not unique: " + this.paths);
                    }
                }
            }
        };
        PathLister.resolveAll(this.getGlobalSheet(), consumer, false);
        return cls.cast(result.module);
    }

    static {
        KeyManager.addKeys(SheetManager.class);
    }
}

