/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.archive.settings.Container;
import org.archive.settings.Duplicator;
import org.archive.settings.Holder;
import org.archive.settings.KeyChangeEvent;
import org.archive.settings.KeyChangeListener;
import org.archive.settings.MapContainer;
import org.archive.settings.ModuleInfo;
import org.archive.settings.MultiTypedList;
import org.archive.settings.MultiTypedMap;
import org.archive.settings.Resolved;
import org.archive.settings.SettingsList;
import org.archive.settings.SettingsMap;
import org.archive.settings.Sheet;
import org.archive.settings.SheetManager;
import org.archive.settings.Stub;
import org.archive.settings.TypedList;
import org.archive.settings.TypedMap;
import org.archive.settings.UnspecifiedSheet;
import org.archive.settings.path.PathChangeException;
import org.archive.state.Constraint;
import org.archive.state.Key;
import org.archive.state.KeyTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleSheet
extends Sheet {
    private static final long serialVersionUID = 1L;
    private transient WeakHashMap<Object, Map<Key<?>, Object>> settings;
    transient WeakHashMap<Object, Holder> holders;
    private final boolean global;
    private transient WeakHashMap<Object, String> primaries;
    private List<KeyChangeEvent> pending;

    SingleSheet(SheetManager manager, String parentName, String name, boolean global) {
        super(manager, parentName, name);
        this.global = global;
        this.settings = new WeakHashMap();
        this.primaries = new WeakHashMap();
        this.holders = new WeakHashMap();
    }

    public boolean isGlobal() {
        return this.global;
    }

    @Override
    SingleSheet duplicate() {
        SingleSheet result = new SingleSheet(this.getSheetManager(), this.parentName, this.getName(), this.global);
        result.primaries.putAll(this.primaries);
        Duplicator d = new Duplicator(this, result);
        for (Map.Entry<Object, Holder> entry : this.holders.entrySet()) {
            Holder n = new Holder();
            n.module = entry.getValue().module;
            result.holders.put(entry.getKey(), n);
        }
        for (Map.Entry<Object, Object> entry : this.settings.entrySet()) {
            Object module = entry.getKey();
            Map settings = (Map)entry.getValue();
            if (module == null || settings == null) continue;
            HashMap settingsClone = new HashMap(settings);
            for (Map.Entry me : settings.entrySet()) {
                Key key = (Key)me.getKey();
                Object value = me.getValue();
                value = d.duplicate(me.getValue());
                if (value == null) continue;
                settingsClone.put(key, value);
            }
            result.settings.put(module, settingsClone);
        }
        return result;
    }

    @Override
    public boolean contains(Object module, Key<?> key) {
        Map<Key<?>, Object> keys = this.settings.get(module);
        if (keys == null) {
            return false;
        }
        return keys.containsKey(key);
    }

    private Object fetch(Object module, Key<?> key) {
        Map<Key<?>, Object> keys = this.settings.get(module);
        if (keys == null) {
            return null;
        }
        return keys.get(key);
    }

    @Override
    Object check(Object module, Key<?> key) {
        Object r = this.fetch(module, key);
        if (r instanceof ModuleInfo) {
            r = ((ModuleInfo)r).holder.module;
        }
        return r;
    }

    @Override
    public <T> Resolved<T> resolve(Object module, Key<T> key) {
        if (module == null) {
            throw new IllegalArgumentException("Requested key on null module.");
        }
        SingleSheet.validateModuleType(module, key);
        if (Map.class.isAssignableFrom(key.getType())) {
            return this.resolveMap(module, key);
        }
        if (List.class.isAssignableFrom(key.getType())) {
            return this.resolveList(module, key);
        }
        if (!this.contains(module, key)) {
            return this.getParent().resolve(module, key);
        }
        Object result = this.fetch(module, key);
        if (result instanceof ModuleInfo) {
            ModuleInfo minfo = (ModuleInfo)result;
            if (this.isLive(key.getType())) {
                T typesafe = key.getType().cast(minfo.holder.module);
                return Resolved.makeLive(module, key, typesafe, this);
            }
            Stub stub = (Stub)minfo.holder.module;
            return Resolved.makeStub(module, key, stub, this);
        }
        T typesafe = key.getType().cast(result);
        return Resolved.makeLive(module, key, typesafe, this);
    }

    private <T> Resolved<T> resolveMap(Object module, Key<T> key) {
        ArrayList<Sheet> sheets = new ArrayList<Sheet>();
        ArrayList maps = new ArrayList();
        Sheet sh = this;
        while (!(sh instanceof UnspecifiedSheet)) {
            if (sh.contains(module, key)) {
                sheets.add(sh);
                Object o = sh.check(module, key);
                TypedMap map = (TypedMap)o;
                maps.add(map);
            }
            sh = sh.getParent();
        }
        if (sheets.isEmpty()) {
            return this.getSheetManager().getUnspecifiedSheet().resolve(module, key);
        }
        MultiTypedMap<Object> result = new MultiTypedMap<Object>(maps, null);
        return Resolved.makeMap(module, key, result, sheets);
    }

    private <T> Resolved<T> resolveList(Object module, Key<T> key) {
        ArrayList<Sheet> sheets = new ArrayList<Sheet>();
        ArrayList lists = new ArrayList();
        Sheet sh = this;
        while (!(sh instanceof UnspecifiedSheet)) {
            if (sh.contains(module, key)) {
                sheets.add(sh);
                Object o = sh.check(module, key);
                TypedList list = (TypedList)o;
                lists.add(0, list);
            }
            sh = sh.getParent();
        }
        if (sheets.isEmpty()) {
            return this.getSheetManager().getUnspecifiedSheet().resolve(module, key);
        }
        MultiTypedList result = new MultiTypedList(lists, null);
        return Resolved.makeList(module, key, result, sheets);
    }

    public void remove(Object module, Key<?> key) {
        if (module == null) {
            throw new IllegalArgumentException("Attempt to remove key value on null module.");
        }
        Map<Key<?>, Object> map = this.settings.get(module);
        if (map == null) {
            return;
        }
        map.remove(key);
    }

    public <T> void set(Object module, Key<T> key, T value) {
        String s;
        if (module == null) {
            throw new IllegalArgumentException("Attempt to set key value on null module.");
        }
        Class<?> vtype = value == null ? null : value.getClass();
        SingleSheet.validateTypes(module, key, vtype);
        T v = key.getType().cast(value);
        for (Constraint<T> c : key.getConstraints()) {
            if (c.allowed(v)) continue;
            if (!this.getSheetManager().isLive()) {
                this.set2(module, key, value);
            }
            throw new PathChangeException("value '" + v + "' disallowed for '" + key.getFieldName() + "' by constraint: " + c);
        }
        if (v instanceof String && ((s = (String)v).indexOf(10) >= 0 || s.indexOf(13) >= 0)) {
            throw new IllegalArgumentException("String values must not contain new lines.");
        }
        this.set2(module, key, value);
    }

    public <T> void setStub(Stub module, Key<T> key, Object value) {
        Class<Object> vtype = value == null ? null : (value instanceof Stub ? ((Stub)value).getType() : value.getClass());
        SingleSheet.validateTypes(module, key, vtype);
        this.set2(module, key, value);
    }

    private <T> void set2(Object module, Key<T> key, Object value) {
        Object old;
        Map<Key<?>, Object> map = this.settings.get(module);
        if (map == null) {
            map = new HashMap();
            this.settings.put(module, map);
        }
        if (SingleSheet.isModuleType(Stub.getType(value = this.transform(value)))) {
            old = this.setModuleValue(map, key, value);
            this.getSheetManager().fireModuleChanged(old, value);
        } else {
            old = map.put(key, value);
        }
        if (module instanceof KeyChangeListener && this.pending != null && !this.eq(old, value)) {
            KeyChangeEvent event = new KeyChangeEvent(this, module, key, old, value);
            this.pending.add(event);
        }
    }

    private Object setModuleValue(Map<Key<?>, Object> map, Key<?> key, Object value) {
        return this.setModuleValue(new MapContainer(map), key, value);
    }

    Object setModuleValue(Container map, Object key, Object value) {
        ModuleInfo minfo = (ModuleInfo)map.get(key);
        Holder holder = this.holders.get(value);
        if (holder == null) {
            Object old;
            Object object = old = minfo == null ? null : minfo.holder.module;
            if (old == value) {
                return old;
            }
            if (minfo != null && minfo.first) {
                minfo.holder.module = value;
                this.holders.put(value, minfo.holder);
                this.primaries.remove(old);
            } else {
                ModuleInfo newInfo = new ModuleInfo();
                holder = new Holder();
                holder.module = value;
                this.holders.put(value, holder);
                newInfo.holder = holder;
                newInfo.first = true;
                map.put(key, newInfo);
            }
            return old;
        }
        if (minfo == null) {
            minfo = new ModuleInfo();
            minfo.holder = holder;
            map.put(key, minfo);
            return null;
        }
        if (minfo.first) {
            Object old = holder.module;
            if (old == value) {
                return old;
            }
            holder.module = value;
            this.holders.remove(old);
            this.holders.put(value, holder);
            this.primaries.remove(old);
            return old;
        }
        Object old = minfo.holder.module;
        minfo.holder = holder;
        return old;
    }

    private boolean eq(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o2 == null) {
            return false;
        }
        if (KeyTypes.isSimple(Stub.getType(o1))) {
            return o1.equals(o2);
        }
        return false;
    }

    private static <T> void validateTypes(Object module, Key<T> key, Class vtype) {
        SingleSheet.validateModuleType(module, key);
        if (vtype != null && !key.getType().isAssignableFrom(vtype)) {
            throw new IllegalArgumentException("Illegal value type for " + key.getFieldName() + ". Expected " + key.getType().getName() + " but got " + vtype.getName());
        }
    }

    private Object transform(Object o) {
        if (o instanceof Map && !(o instanceof SettingsMap)) {
            throw new IllegalArgumentException("Maps must be TypedMap.");
        }
        if (o instanceof List && !(o instanceof SettingsList)) {
            throw new IllegalArgumentException("Lists must be TypedList.");
        }
        return o;
    }

    public <T> Map<String, T> resolveEditableMap(Object o, Key<Map<String, T>> k) {
        Map result = (Map)this.check(o, k);
        return result;
    }

    public List resolveEditableList(Object o, Key<List> k) {
        List result = (List)this.check(o, k);
        return result;
    }

    @Override
    SingleSheet getGlobalSheet() {
        if (this.global) {
            return this;
        }
        return this.getSheetManager().getGlobalSheet();
    }

    List<KeyChangeEvent> clearKeyChangeEvents() {
        List<KeyChangeEvent> result = this.pending;
        this.pending = null;
        return result;
    }

    @Override
    void setClone(boolean clone) {
        super.setClone(clone);
        if (clone) {
            this.pending = new ArrayList<KeyChangeEvent>();
        }
    }

    public void addPrimary(Object primary) {
        this.primaries.put(primary, "");
    }

    public void removePrimary(Object primary) {
        this.primaries.remove(primary);
    }

    public boolean isPrimary(Object primary) {
        return this.primaries.containsKey(primary);
    }

    public Object findPrimary(Class<?> type) {
        Object result = null;
        for (Object o : this.primaries.keySet()) {
            Class otype = Stub.getType(o);
            if (!type.isAssignableFrom(otype)) continue;
            if (result != null) {
                throw new IllegalStateException("More than one primary found for " + type.getName());
            }
            result = o;
        }
        return result;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        Map map = (Map)input.readObject();
        this.primaries = new WeakHashMap(map);
        map = (Map)input.readObject();
        this.holders = new WeakHashMap(map);
        map = (Map)input.readObject();
        this.settings = new WeakHashMap(map);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        HashMap<Object, String> map = new HashMap<Object, String>(this.primaries);
        output.writeObject(map);
        output.writeObject(new HashMap<Object, Holder>(this.holders));
        output.writeObject(new HashMap(this.settings));
    }

    static boolean isModuleType(Class<?> c) {
        if (KeyTypes.isSimple(c)) {
            return false;
        }
        if (List.class.isAssignableFrom(c)) {
            return false;
        }
        return !Map.class.isAssignableFrom(c);
    }
}

