/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.archive.settings.Sheet;
import org.archive.settings.TypedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnmodifiableTypedMap<T>
extends AbstractMap<String, T>
implements TypedMap<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, T> delegate;
    private Class<T> elementType;
    private Sheet sheet;

    public UnmodifiableTypedMap(TypedMap<T> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
        this.elementType = delegate.getElementType();
    }

    public UnmodifiableTypedMap(Sheet sheet, Map<String, T> map, Class<T> elementType) {
        this.delegate = map;
        this.sheet = sheet;
        this.elementType = elementType;
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public T get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.delegate.keySet());
    }

    @Override
    public Collection<T> values() {
        return Collections.unmodifiableCollection(this.delegate.values());
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return Collections.unmodifiableSet(this.delegate.entrySet());
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    @Override
    public List<Sheet> getSheets(String key) {
        if (this.delegate instanceof TypedMap) {
            TypedMap tm = (TypedMap)this.delegate;
            return tm.getSheets(key);
        }
        return Collections.singletonList(this.sheet);
    }
}

