/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.archive.settings.Resolved;
import org.archive.settings.Sheet;
import org.archive.settings.SheetManager;
import org.archive.settings.SingleSheet;
import org.archive.settings.Stub;
import org.archive.settings.UnmodifiableTypedList;
import org.archive.settings.UnmodifiableTypedMap;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyTypes;
import org.archive.state.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnspecifiedSheet
extends Sheet {
    private static final long serialVersionUID = 1L;
    private final List<Sheet> thisList = Collections.singletonList(this);
    private ConcurrentHashMap<ModuleKey, Object> defaults = new ConcurrentHashMap();

    public UnspecifiedSheet(SheetManager manager, String name) {
        super(manager, null, name);
    }

    @Override
    UnspecifiedSheet duplicate() {
        return this;
    }

    @Override
    Object check(Object module, Key<?> key) {
        return this.get(module, key);
    }

    <T> Object getDefault(SingleSheet global, Object module, Key<T> k) {
        Object r;
        Class<T> type = k.getType();
        if (KeyTypes.isSimple(type)) {
            if (Path.class.isAssignableFrom(type)) {
                Path p = (Path)k.getDefaultValue();
                p = new Path(this.getSheetManager().getPathContext(), p.toString());
                return p;
            }
            return k.getDefaultValue();
        }
        if (k.isAutoDetected()) {
            return global.findPrimary(type);
        }
        ModuleKey mk = new ModuleKey(module, k);
        Object result = this.defaults.get(mk);
        if (result != null) {
            if (result == NULL.VALUE) {
                return null;
            }
            return result;
        }
        if (type == List.class) {
            ArrayList<Object> list;
            if (KeyTypes.isSimple(k.getElementType())) {
                list = (ArrayList<Object>)k.getDefaultValue();
            } else {
                List<Class<?>> orig = k.getDefaultListElementImplementations();
                list = new ArrayList<Object>();
                for (Class<?> c : orig) {
                    list.add(this.create(c));
                }
            }
            result = new UnmodifiableTypedList(this, list, k.getElementType());
        } else if (type == Map.class) {
            LinkedHashMap<String, Object> map;
            if (KeyTypes.isSimple(k.getElementType())) {
                map = (LinkedHashMap<String, Object>)k.getDefaultValue();
            } else {
                Map<String, Class<?>> orig = k.getDefaultMapElementImplementations();
                map = new LinkedHashMap<String, Object>();
                for (Map.Entry<String, Class<?>> me : orig.entrySet()) {
                    map.put(me.getKey(), this.create(me.getValue()));
                }
            }
            result = new UnmodifiableTypedMap(this, map, k.getElementType());
        } else {
            result = this.create(k.getDefaultImplementation());
        }
        if (result == null) {
            result = NULL.VALUE;
        }
        if ((r = this.defaults.putIfAbsent(mk, result)) != null) {
            result = r;
        }
        if (result == NULL.VALUE) {
            return null;
        }
        return result;
    }

    private Object create(Class<?> c) {
        if (c == null) {
            return null;
        }
        if (this.getSheetManager().isLive()) {
            try {
                Object o = c.newInstance();
                if (o instanceof Initializable) {
                    ((Initializable)o).initialTasks(this);
                }
                return o;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return Stub.make(c);
    }

    @Override
    public <T> T get(Object module, Key<T> k) {
        UnspecifiedSheet.validateModuleType(module, k);
        SingleSheet global = this.getSheetManager().getGlobalSheet();
        Object value = this.getDefault(global, module, k);
        return k.getType().cast(value);
    }

    @Override
    public <T> Resolved<T> resolve(Object module, Key<T> k) {
        UnspecifiedSheet.validateModuleType(module, k);
        SingleSheet global = this.getSheetManager().getGlobalSheet();
        Object value = this.getDefault(global, module, k);
        return Resolved.make(module, k, value, this.thisList);
    }

    @Override
    public boolean contains(Object module, Key<?> k) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModuleKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Object module;
        private Key<?> key;

        public ModuleKey(Object module, Key<?> key) {
            this.module = module;
            this.key = key;
        }

        public int hashCode() {
            return this.module.hashCode() ^ this.key.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ModuleKey)) {
                return false;
            }
            ModuleKey mk = (ModuleKey)other;
            return this.module == mk.module && this.key == mk.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NULL {
        VALUE;

    }
}

