/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.file;

import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.DbLsn;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.settings.CheckpointRecovery;
import org.archive.settings.RecoverAction;
import org.archive.settings.file.Checkpointable;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Module;
import org.archive.state.StateProvider;
import org.archive.util.CachedBdbMap;
import org.archive.util.FileUtils;
import org.archive.util.bdbje.EnhancedEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BdbModule
implements Module,
Initializable,
Checkpointable,
Serializable,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(BdbModule.class.getName());
    private static final long serialVersionUID = 1L;
    @Immutable
    public static final Key<String> DIR = Key.make("state");
    @Immutable
    public static final Key<Integer> BDB_CACHE_PERCENT = Key.make(60);
    @Immutable
    public static final Key<Boolean> CHECKPOINT_COPY_BDBJE_LOGS = Key.make(true);
    private boolean checkpointCopy;
    private String path;
    private int cachePercent;
    private transient EnhancedEnvironment bdbEnvironment;
    private transient Database classCatalogDB;
    private transient StoredClassCatalog classCatalog;
    private Map<String, CachedBdbMap> bigMaps = new ConcurrentHashMap<String, CachedBdbMap>();
    private Map<String, DatabasePlusConfig> databases = new ConcurrentHashMap<String, DatabasePlusConfig>();
    private transient Thread shutdownHook;

    @Override
    public void initialTasks(StateProvider provider) {
        this.checkpointCopy = provider.get(this, CHECKPOINT_COPY_BDBJE_LOGS);
        this.cachePercent = provider.get(this, BDB_CACHE_PERCENT);
        this.path = provider.get(this, DIR);
        try {
            this.setUp(this.path, this.cachePercent, true);
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
        this.shutdownHook = new BdbShutdownHook(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private void setUp(String path, int cachePercent, boolean create) throws DatabaseException {
        EnvironmentConfig config = new EnvironmentConfig();
        config.setAllowCreate(create);
        config.setLockTimeout(5000000L);
        config.setCachePercent(cachePercent);
        File f = new File(path);
        f.mkdirs();
        this.bdbEnvironment = new EnhancedEnvironment(f, config);
        this.classCatalog = this.bdbEnvironment.getClassCatalog();
    }

    public void closeDatabase(Database db) {
        try {
            this.closeDatabase(db.getDatabaseName());
        }
        catch (DatabaseException e) {
            LOGGER.log(Level.SEVERE, "Error getting db name", e);
        }
    }

    public void closeDatabase(String name) {
        DatabasePlusConfig dpc = this.databases.remove(name);
        if (dpc == null) {
            throw new IllegalStateException("No such database: " + name);
        }
        Database db = dpc.database;
        try {
            db.sync();
            db.close();
        }
        catch (DatabaseException e) {
            LOGGER.log(Level.SEVERE, "Error closing db " + name, e);
        }
    }

    public Database openDatabase(String name, BdbConfig config, boolean recycle) throws DatabaseException {
        if (this.databases.containsKey(name)) {
            throw new IllegalStateException("Database already exists: " + name);
        }
        if (!recycle) {
            try {
                this.bdbEnvironment.truncateDatabase(null, name, false);
            }
            catch (DatabaseNotFoundException e) {
                // empty catch block
            }
        }
        DatabasePlusConfig dpc = new DatabasePlusConfig();
        dpc.database = this.bdbEnvironment.openDatabase(null, name, config.toDatabaseConfig());
        dpc.name = name;
        dpc.config = config;
        this.databases.put(name, dpc);
        return dpc.database;
    }

    public SecondaryDatabase openSecondaryDatabase(String name, Database db, SecondaryBdbConfig config) throws DatabaseException {
        if (this.databases.containsKey(name)) {
            throw new IllegalStateException("Database already exists: " + name);
        }
        SecondaryDatabase result = this.bdbEnvironment.openSecondaryDatabase(null, name, db, config.toSecondaryConfig());
        DatabasePlusConfig dpc = new DatabasePlusConfig();
        dpc.database = result;
        dpc.name = name;
        dpc.primaryName = db.getDatabaseName();
        dpc.config = config;
        this.databases.put(name, dpc);
        return result;
    }

    public StoredClassCatalog getClassCatalog() {
        return this.classCatalog;
    }

    public <K, V> Map<K, V> getBigMap(String dbName, boolean recycle, Class<? super K> key, Class<? super V> value) throws DatabaseException {
        CachedBdbMap r = this.bigMaps.get(dbName);
        if (r != null) {
            return r;
        }
        if (!recycle) {
            try {
                this.bdbEnvironment.truncateDatabase(null, dbName, false);
            }
            catch (DatabaseNotFoundException e) {
                // empty catch block
            }
        }
        r = new CachedBdbMap(dbName);
        r.initialize(this.bdbEnvironment, key, value, this.classCatalog);
        this.bigMaps.put(dbName, r);
        return r;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in instanceof CheckpointRecovery) {
            CheckpointRecovery cr = (CheckpointRecovery)((Object)in);
            this.path = cr.translatePath(this.path);
            cr.setState(this, DIR, this.path);
        }
        try {
            this.setUp(this.path, this.cachePercent, false);
            for (CachedBdbMap map : this.bigMaps.values()) {
                map.initialize(this.bdbEnvironment, map.getKeyClass(), map.getValueClass(), this.classCatalog);
            }
            for (DatabasePlusConfig dpc : this.databases.values()) {
                if (dpc.config instanceof SecondaryBdbConfig) continue;
                dpc.database = this.bdbEnvironment.openDatabase(null, dpc.name, dpc.config.toDatabaseConfig());
            }
            for (DatabasePlusConfig dpc : this.databases.values()) {
                if (!(dpc.config instanceof SecondaryBdbConfig)) continue;
                SecondaryBdbConfig conf = (SecondaryBdbConfig)dpc.config;
                Database primary = this.databases.get((Object)dpc.primaryName).database;
                dpc.database = this.bdbEnvironment.openSecondaryDatabase(null, dpc.name, primary, conf.toSecondaryConfig());
            }
        }
        catch (DatabaseException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
        this.shutdownHook = new BdbShutdownHook(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    @Override
    public void checkpoint(File dir, List<RecoverAction> actions) throws IOException {
        EnvironmentConfig envConfig;
        if (this.checkpointCopy) {
            actions.add(new BdbRecover(this.path));
        }
        for (Map.Entry<String, CachedBdbMap> me : this.bigMaps.entrySet()) {
            me.getValue().sync();
        }
        try {
            for (DatabasePlusConfig dbc : this.databases.values()) {
                dbc.database.sync();
            }
            envConfig = this.bdbEnvironment.getConfig();
        }
        catch (DatabaseException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
        List<String> bkgrdThreads = Arrays.asList("je.env.runCheckpointer", "je.env.runCleaner", "je.env.runINCompressor");
        try {
            this.setBdbjeBkgrdThreads(envConfig, bkgrdThreads, "false");
            CheckpointConfig chkptConfig = new CheckpointConfig();
            chkptConfig.setForce(true);
            chkptConfig.setMinimizeRecoveryTime(true);
            this.bdbEnvironment.checkpoint(chkptConfig);
            LOGGER.fine("Finished bdb checkpoint.");
            EnvironmentImpl envImpl = DbInternal.envGetEnvironmentImpl((Environment)this.bdbEnvironment);
            long firstFileInNextSet = DbLsn.getFileNumber((long)envImpl.forceLogFileFlip());
            String lastBdbCheckpointLog = this.getBdbLogFileName(firstFileInNextSet - 1L);
            this.processBdbLogs(dir, lastBdbCheckpointLog);
            LOGGER.fine("Finished processing bdb log files.");
        }
        catch (DatabaseException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
        finally {
            this.setBdbjeBkgrdThreads(envConfig, bkgrdThreads, "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBdbLogs(File checkpointDir, String lastBdbCheckpointLog) throws IOException {
        File bdbDir = BdbModule.getBdbSubDirectory(checkpointDir);
        if (!bdbDir.exists()) {
            bdbDir.mkdir();
        }
        PrintWriter pw = new PrintWriter(new FileOutputStream(new File(checkpointDir, "bdbje-logs-manifest.txt")));
        try {
            boolean pastLastLogFile = false;
            AbstractSet srcFilenames = null;
            do {
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name != null && name.toLowerCase().endsWith(".jdb");
                    }
                };
                srcFilenames = new HashSet<String>(Arrays.asList(new File(this.path).list(filter)));
                List<String> tgtFilenames = Arrays.asList(bdbDir.list(filter));
                if (tgtFilenames != null && tgtFilenames.size() > 0) {
                    srcFilenames.removeAll(tgtFilenames);
                }
                if (srcFilenames.size() <= 0) continue;
                srcFilenames = new TreeSet<String>(srcFilenames);
                int count = 0;
                Iterator i = srcFilenames.iterator();
                while (i.hasNext() && !pastLastLogFile) {
                    String name = (String)i.next();
                    if (this.checkpointCopy) {
                        FileUtils.copyFiles(new File(this.path, name), new File(bdbDir, name));
                    }
                    pw.println(name);
                    if (name.equals(lastBdbCheckpointLog)) {
                        pastLastLogFile = true;
                    }
                    ++count;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Copied " + count);
            } while (!pastLastLogFile && srcFilenames != null && srcFilenames.size() > 0);
        }
        finally {
            pw.close();
        }
    }

    private void setBdbjeBkgrdThreads(EnvironmentConfig config, List threads, String setting) {
        Iterator i = threads.iterator();
        while (i.hasNext()) {
            config.setConfigParam((String)i.next(), setting);
        }
    }

    private String getBdbLogFileName(long index) {
        String lastBdbLogFileHex = Long.toHexString(index);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 8 - lastBdbLogFileHex.length(); ++i) {
            buffer.append('0');
        }
        buffer.append(lastBdbLogFileHex);
        buffer.append(".jdb");
        return buffer.toString();
    }

    @Override
    public void close() {
        this.close2();
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
    }

    void close2() {
        if (this.classCatalog == null) {
            return;
        }
        for (Map.Entry<String, CachedBdbMap> me : this.bigMaps.entrySet()) {
            try {
                me.getValue().close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error closing bigMap " + me.getKey(), e);
            }
        }
        ArrayList<String> dbNames = new ArrayList<String>(this.databases.keySet());
        for (String dbName : dbNames) {
            try {
                this.closeDatabase(dbName);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error closing db " + dbName, e);
            }
        }
        try {
            this.bdbEnvironment.sync();
            this.bdbEnvironment.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error closing environment.", e);
        }
    }

    private static File getBdbSubDirectory(File checkpointDir) {
        return new File(checkpointDir, "bdbje-logs");
    }

    public Database getDatabase(String name) {
        DatabasePlusConfig dpc = this.databases.get(name);
        if (dpc == null) {
            return null;
        }
        return dpc.database;
    }

    static {
        KeyManager.addKeys(BdbModule.class);
    }

    private static class BdbShutdownHook
    extends Thread {
        private final BdbModule bdb;

        public BdbShutdownHook(BdbModule bdb) {
            this.bdb = bdb;
        }

        public void run() {
            this.bdb.close2();
        }
    }

    private static class BdbRecover
    implements RecoverAction {
        private static final long serialVersionUID = 1L;
        private String path;

        public BdbRecover(String path) {
            this.path = path;
        }

        public void recoverFrom(File checkpointDir, CheckpointRecovery recovery) throws Exception {
            File bdbDir = BdbModule.getBdbSubDirectory(checkpointDir);
            this.path = recovery.translatePath(this.path);
            FileUtils.copyFiles(bdbDir, new File(this.path));
        }
    }

    public static class SecondaryBdbConfig
    extends BdbConfig {
        private static final long serialVersionUID = 1L;
        private SecondaryKeyCreator keyCreator;

        public SecondaryKeyCreator getKeyCreator() {
            return this.keyCreator;
        }

        public void setKeyCreator(SecondaryKeyCreator keyCreator) {
            this.keyCreator = keyCreator;
        }

        public SecondaryConfig toSecondaryConfig() {
            SecondaryConfig result = new SecondaryConfig();
            result.setDeferredWrite(true);
            result.setTransactional(this.transactional);
            result.setAllowCreate(this.allowCreate);
            result.setSortedDuplicates(this.sortedDuplicates);
            result.setKeyCreator(this.keyCreator);
            return result;
        }
    }

    public static class BdbConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        boolean allowCreate;
        boolean sortedDuplicates;
        boolean transactional;

        public boolean isAllowCreate() {
            return this.allowCreate;
        }

        public void setAllowCreate(boolean allowCreate) {
            this.allowCreate = allowCreate;
        }

        public boolean getSortedDuplicates() {
            return this.sortedDuplicates;
        }

        public void setSortedDuplicates(boolean sortedDuplicates) {
            this.sortedDuplicates = sortedDuplicates;
        }

        public DatabaseConfig toDatabaseConfig() {
            DatabaseConfig result = new DatabaseConfig();
            result.setDeferredWrite(true);
            result.setTransactional(this.transactional);
            result.setAllowCreate(this.allowCreate);
            result.setSortedDuplicates(this.sortedDuplicates);
            return result;
        }

        public boolean isTransactional() {
            return this.transactional;
        }

        public void setTransactional(boolean transactional) {
            this.transactional = transactional;
        }
    }

    private static class DatabasePlusConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public transient Database database;
        public String name;
        public String primaryName;
        public BdbConfig config;

        private DatabasePlusConfig() {
        }
    }
}

