/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.file;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.archive.settings.CheckpointRecovery;
import org.archive.state.PathContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FSMPathContext
implements PathContext,
Serializable {
    public static final String CURRENT_JOB = "current.job";
    public static final String ORIGINAL_JOB = "original.job";
    public static final String JOB_PREFIX = "job.prefix";
    private static final long serialVersionUID = 1L;
    private File baseDir;
    private Map<String, String> vars;

    public FSMPathContext(File baseDir, String jobName) {
        this.baseDir = baseDir;
        this.vars = new HashMap<String, String>();
        this.vars.put(CURRENT_JOB, jobName);
        this.vars.put(ORIGINAL_JOB, jobName);
        this.vars.put(JOB_PREFIX, FSMPathContext.getPrefix(jobName));
    }

    @Override
    public Map<String, String> getPathVariables() {
        return Collections.unmodifiableMap(this.vars);
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
        inp.defaultReadObject();
        if (inp instanceof CheckpointRecovery) {
            CheckpointRecovery cr = (CheckpointRecovery)((Object)inp);
            this.baseDir = new File(cr.translatePath(this.baseDir.getAbsolutePath()));
            HashMap<String, String> newVars = new HashMap<String, String>();
            newVars.put(CURRENT_JOB, cr.getRecoveredJobName());
            newVars.put(ORIGINAL_JOB, this.vars.get(ORIGINAL_JOB));
            newVars.put(JOB_PREFIX, FSMPathContext.getPrefix(cr.getRecoveredJobName()));
            this.vars = newVars;
        }
    }

    private static String getPrefix(String job) {
        int p = job.lastIndexOf(45);
        return p > 0 ? job.substring(0, p) : job;
    }
}

