/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.file;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.archive.settings.path.StringPathListConsumer;

public class FilePathListConsumer
extends StringPathListConsumer {
    final Writer writer;
    private char sheetsDelim = (char)9;
    private char pathDelim = (char)61;
    private String typeDelim = ", ";
    private boolean includeSheets = false;

    public FilePathListConsumer(OutputStream output) {
        try {
            this.writer = new OutputStreamWriter(output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException();
        }
    }

    public FilePathListConsumer(StringWriter writer) {
        this.writer = writer;
    }

    public void setIncludeSheets(boolean b) {
        this.includeSheets = b;
    }

    public void setSheetsDelim(char ch) {
        this.sheetsDelim = ch;
    }

    public void setPathDelim(char ch) {
        this.pathDelim = ch;
    }

    public void setTypeDelim(String d) {
        this.typeDelim = d;
    }

    protected void consume(String path, String[] sheets, String value, String type) {
        try {
            this.consume2(path, sheets, value, type);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void consume2(String path, String[] sheets, String value, String type) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (this.includeSheets) {
            sb.append(sheets[0]);
            for (int i = 1; i < sheets.length; ++i) {
                sb.append(',').append(sheets[i]);
            }
            sb.append(this.sheetsDelim);
        }
        sb.append(path).append(this.pathDelim);
        sb.append(type).append(this.typeDelim);
        sb.append(value);
        sb.append('\n');
        this.writer.write(sb.toString());
        this.writer.flush();
    }
}

