/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.file;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.settings.Association;
import org.archive.settings.CheckpointRecovery;
import org.archive.settings.ModuleListener;
import org.archive.settings.RecoverAction;
import org.archive.settings.Sheet;
import org.archive.settings.SheetManager;
import org.archive.settings.SingleSheet;
import org.archive.settings.Stub;
import org.archive.settings.file.BdbModule;
import org.archive.settings.file.Checkpointable;
import org.archive.settings.file.FSMPathContext;
import org.archive.settings.file.FilePathListConsumer;
import org.archive.settings.file.PrefixFinder;
import org.archive.settings.file.SheetFileReader;
import org.archive.settings.path.ConstraintChecker;
import org.archive.settings.path.PathChangeException;
import org.archive.settings.path.PathChanger;
import org.archive.settings.path.PathLister;
import org.archive.state.ExampleStateProvider;
import org.archive.state.Immutable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.PathContext;
import org.archive.util.FileUtils;
import org.archive.util.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSheetManager
extends SheetManager
implements Checkpointable {
    private static final long serialVersionUID = 1L;
    @Immutable
    public static final Key<BdbModule> BDB = Key.make(BdbModule.class, null);
    @Immutable
    public static final Key<Path> DIR = Key.make(new Path("."));
    private static final String ATTR_SHEETS = "sheets-dir";
    private static final String BDB_PREFIX = "bdb-";
    private static final String DEFAULT_SHEETS = "sheets";
    private static final String SINGLE_EXT = ".sheet";
    private static final Logger LOGGER;
    private File sheetsDir;
    private transient File mainConfig;
    private Map<String, Sheet> sheets;
    private transient Database surtToSheetsDB;
    private transient StoredSortedMap surtToSheets;
    private PathContext pathContext;
    private SingleSheet defaultSheet;
    private final Map<String, List<PathChangeException>> problems = new HashMap<String, List<PathChangeException>>();
    private final BdbModule bdb;
    private final Path dir;
    private String bdbDir;
    private final int bdbCachePercent;
    private boolean copyCheckpoint;

    public FileSheetManager(File main, String name, boolean live) throws IOException, DatabaseException {
        this(main, name, live, FileSheetManager.emptyList());
    }

    public FileSheetManager(File main, String name, boolean live, Collection<ModuleListener> listeners) throws IOException, DatabaseException {
        super(name, listeners, live);
        this.mainConfig = main;
        this.pathContext = new FSMPathContext(this.mainConfig.getParentFile(), name);
        Properties p = FileSheetManager.load(main);
        String path = this.getBdbProperty(p, BdbModule.DIR);
        File f = new File(path);
        if (!f.isAbsolute()) {
            f = new File(this.mainConfig.getParent(), path);
        }
        this.bdbDir = f.getAbsolutePath();
        this.bdbCachePercent = live ? Integer.parseInt(this.getBdbProperty(p, BdbModule.BDB_CACHE_PERCENT)) : Integer.parseInt(p.getProperty("bdb-stub-cache-percent", "5"));
        String truthiness = this.getBdbProperty(p, BdbModule.CHECKPOINT_COPY_BDBJE_LOGS);
        if (truthiness.equals("true")) {
            this.copyCheckpoint = true;
        } else if (truthiness.equals("false")) {
            this.copyCheckpoint = false;
        } else {
            throw new IllegalStateException("Illegal boolean: " + truthiness);
        }
        ExampleStateProvider dsp = new ExampleStateProvider();
        this.dir = new Path(main.getParentFile().getAbsolutePath());
        this.bdb = new BdbModule();
        dsp.set(this.bdb, BdbModule.DIR, this.bdbDir);
        dsp.set(this.bdb, BdbModule.BDB_CACHE_PERCENT, this.bdbCachePercent);
        dsp.set(this.bdb, BdbModule.CHECKPOINT_COPY_BDBJE_LOGS, this.copyCheckpoint);
        this.bdb.initialTasks(dsp);
        String prop = p.getProperty(ATTR_SHEETS);
        this.sheetsDir = FileSheetManager.getRelative(main, prop, DEFAULT_SHEETS);
        this.validateDir(this.sheetsDir);
        this.sheets = new HashMap<String, Sheet>();
        this.initBdb();
        this.reload();
    }

    private void initBdb() throws DatabaseException {
        BdbModule.BdbConfig config = new BdbModule.BdbConfig();
        config.setAllowCreate(true);
        config.setSortedDuplicates(true);
        this.surtToSheetsDB = this.bdb.openDatabase("surtToSheets", config, true);
        TupleBinding stringBinding = TupleBinding.getPrimitiveBinding(String.class);
        this.surtToSheets = new StoredSortedMap(this.surtToSheetsDB, (EntryBinding)stringBinding, (EntryBinding)stringBinding, true);
    }

    private String getBdbProperty(Properties p, Key<?> key) {
        String propName = BDB_PREFIX + key.getFieldName();
        String defValue = key.getDefaultValue().toString();
        return p.getProperty(propName, defValue);
    }

    private static List<ModuleListener> emptyList() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties load(File file) throws IOException {
        FileInputStream finp = new FileInputStream(file);
        try {
            Properties p = new Properties();
            p.load(finp);
            Properties properties = p;
            return properties;
        }
        finally {
            IoUtils.close(finp);
        }
    }

    private static File getRelative(File main, String prop, String def) {
        if (prop == null) {
            return new File(main.getParentFile(), def);
        }
        File r = new File(prop);
        if (r.isAbsolute()) {
            return r;
        }
        r = new File(main.getParentFile(), prop);
        return r;
    }

    private void validateDir(File f) {
        if (!f.exists()) {
            throw new IllegalArgumentException(f.getAbsolutePath() + " does not exist.");
        }
        if (!f.isDirectory()) {
            throw new IllegalArgumentException(f.getAbsolutePath() + " is not a directory.");
        }
        if (!f.canRead()) {
            throw new IllegalArgumentException(f.getAbsolutePath() + " is unreadable.");
        }
        if (!f.canWrite()) {
            throw new IllegalArgumentException(f.getAbsolutePath() + " is unwriteable.");
        }
    }

    private void reload() {
        this.sheets.clear();
        this.defaultSheet = this.loadSingleSheet("global");
        if (this.defaultSheet == null) {
            throw new IllegalStateException("Could not load default sheet.");
        }
        this.sheets.put("global", this.defaultSheet);
        for (File f : this.sheetsDir.listFiles()) {
            String name = f.getName();
            if (name.equals("global.sheet") || !name.endsWith(SINGLE_EXT)) continue;
            int p = name.lastIndexOf(46);
            String sname = name.substring(0, p);
            this.loadSingleSheet(sname);
        }
    }

    @Override
    public SingleSheet addSingleSheet(String name) {
        SingleSheet r = this.createSingleSheet(this.getGlobalSheet(), name);
        this.addSheet(r);
        return r;
    }

    private void addSheet(SingleSheet sheet) {
        String name = sheet.getName();
        String ext = this.getSheetExtension(name);
        if (ext != null) {
            throw new IllegalArgumentException("Sheet already exists: " + name);
        }
        this.saveSingleSheet(sheet);
        this.sheets.put(name, sheet);
    }

    @Override
    public void associate(Sheet sheet, Collection<String> strings) {
        for (String s : strings) {
            this.surtToSheets.put((Object)s, (Object)sheet.getName());
        }
        try {
            this.surtToSheetsDB.sync();
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void disassociate(Sheet sheet, Collection<String> strings) {
        for (String s : strings) {
            this.surtToSheets.duplicates((Object)s).remove(sheet.getName());
        }
        try {
            this.surtToSheetsDB.sync();
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Collection<String> getAssociations(String context) {
        return this.surtToSheets.duplicates((Object)context);
    }

    @Override
    public Set<String> getContexts() {
        return this.surtToSheets.keySet();
    }

    @Override
    public List<Association> findConfigNames(String uri) {
        ArrayList<Association> result = new ArrayList<Association>();
        ArrayList<String> prefixes = new ArrayList<String>();
        PrefixFinder.find((SortedSet)this.surtToSheets.keySet(), uri, prefixes);
        for (String prefix : prefixes) {
            Collection all = this.surtToSheets.duplicates((Object)prefix);
            for (String surt : all) {
                result.add(new Association(prefix, surt));
            }
        }
        return result;
    }

    @Override
    public Sheet findConfig(String context) {
        ArrayList<Sheet> sheets = new ArrayList<Sheet>();
        ArrayList<String> prefixes = new ArrayList<String>();
        PrefixFinder.find((SortedSet)this.surtToSheets.keySet(), context, prefixes);
        for (String prefix : prefixes) {
            Collection all = this.surtToSheets.duplicates((Object)prefix);
            for (String sheetName : all) {
                try {
                    Sheet sheet = this.getSheet(sheetName);
                    sheets.add(sheet);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warning("Association had unknown sheet: " + sheetName);
                }
            }
        }
        if (sheets.isEmpty()) {
            return this.getGlobalSheet();
        }
        if (sheets.size() == 1) {
            return (Sheet)sheets.get(0);
        }
        return this.createSheetBundle("anonymous", sheets);
    }

    @Override
    public SingleSheet getGlobalSheet() {
        return (SingleSheet)this.getSheet("global");
    }

    @Override
    public Sheet getSheet(String sheetName) throws IllegalArgumentException {
        if (sheetName.equals("default")) {
            return this.getUnspecifiedSheet();
        }
        Sheet r = this.sheets.get(sheetName);
        if (r == null) {
            r = this.loadSheet(sheetName);
            if (r == null) {
                throw new IllegalArgumentException("No such sheet: " + sheetName);
            }
            this.sheets.put(sheetName, r);
        }
        return r;
    }

    @Override
    public Set<String> getSheetNames() {
        String[] files = this.sheetsDir.list();
        HashSet<String> r = new HashSet<String>();
        for (String s : files) {
            String name = this.removeSuffix(s, SINGLE_EXT);
            if (name == null) continue;
            r.add(name);
        }
        return r;
    }

    private String removeSuffix(String s, String suffix) {
        if (s.endsWith(suffix)) {
            return s.substring(0, s.length() - suffix.length());
        }
        return null;
    }

    @Override
    public void removeSheet(String sheetName) throws IllegalArgumentException {
        this.sheets.remove(sheetName);
        String ext = this.getSheetExtension(sheetName);
        if (ext == null) {
            throw new IllegalArgumentException(sheetName + " does not exist.");
        }
        if (!new File(this.sheetsDir, sheetName + ext).delete()) {
            throw new IllegalStateException("Could not delete sheet.");
        }
    }

    @Override
    public void renameSheet(String oldName, String newName) {
        File renamed;
        String prior = this.getSheetExtension(newName);
        if (prior != null) {
            throw new IllegalArgumentException(newName + " already exists.");
        }
        String ext = this.getSheetExtension(oldName);
        if (ext == null) {
            throw new IllegalArgumentException("No such sheet: " + oldName);
        }
        File orig = new File(this.sheetsDir, oldName + ext);
        if (!orig.renameTo(renamed = new File(this.sheetsDir, newName + ext))) {
            throw new IllegalStateException("Rename from " + oldName + " to " + newName + " failed.");
        }
        Sheet s = this.sheets.remove(oldName);
        if (s != null) {
            this.sheets.put(newName, s);
        }
    }

    private Sheet loadSheet(String name) {
        if (new File(this.sheetsDir, name + SINGLE_EXT).exists()) {
            return this.loadSingleSheet(name);
        }
        return null;
    }

    private SingleSheet loadSingleSheet(String name) {
        File f = new File(this.sheetsDir, name + SINGLE_EXT);
        try {
            SingleSheet r = name.equals("global") ? this.createSingleSheet(null, name) : this.createSingleSheet(this.getGlobalSheet(), name);
            if (name.equals("global")) {
                this.setManagerDefaults(r);
            }
            this.sheets.put(name, r);
            SheetFileReader sfr = new SheetFileReader(new FileInputStream(f));
            PathChanger pc = new PathChanger();
            pc.change(r, sfr);
            List<PathChangeException> problems = pc.getProblems();
            ConstraintChecker plc = new ConstraintChecker(problems, r);
            PathLister.resolveAll(r, plc, true);
            if (!problems.isEmpty()) {
                this.problems.put(name, problems);
            }
            return r;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not load sheet.", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSingleSheet(SingleSheet ss) {
        File temp = new File(this.sheetsDir, ss.getName() + SINGLE_EXT + ".temp");
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(temp);
            FilePathListConsumer c = new FilePathListConsumer(fout);
            PathLister.getAll(ss, c, true);
            fout.flush();
        }
        catch (Exception e) {
            try {
                LOGGER.log(Level.SEVERE, "Can't save " + ss.getName(), e);
            }
            catch (Throwable throwable) {
                IoUtils.close(fout);
                throw throwable;
            }
            IoUtils.close(fout);
            return;
        }
        IoUtils.close(fout);
        File saved = new File(this.sheetsDir, ss.getName() + SINGLE_EXT);
        try {
            org.apache.commons.io.FileUtils.copyFile((File)temp, (File)saved, (boolean)true);
            org.apache.commons.io.FileUtils.forceDelete((File)temp);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not rename temp file for " + ss.getName(), e);
        }
    }

    private String getSheetExtension(String sheetName) {
        if (new File(this.sheetsDir, sheetName + SINGLE_EXT).exists()) {
            return SINGLE_EXT;
        }
        return null;
    }

    private void setManagerDefaults(SingleSheet ss) {
        if (this.isLive()) {
            ss.set(this, MANAGER, this);
            ss.set(this, BDB, this.bdb);
            ss.set(this, DIR, this.dir);
            ss.set(this.bdb, BdbModule.DIR, this.bdbDir);
            ss.set(this.bdb, BdbModule.BDB_CACHE_PERCENT, this.bdbCachePercent);
            ss.set(this.bdb, BdbModule.CHECKPOINT_COPY_BDBJE_LOGS, this.copyCheckpoint);
            ss.addPrimary(this.getManagerModule());
            ss.addPrimary(this.bdb);
        } else {
            Stub manager = (Stub)this.getManagerModule();
            Stub<BdbModule> bdb = Stub.make(BdbModule.class);
            ss.setStub(manager, MANAGER, manager);
            ss.setStub(manager, BDB, bdb);
            ss.setStub(manager, DIR, this.dir);
            ss.set(bdb, BdbModule.DIR, this.bdbDir);
            ss.set(bdb, BdbModule.BDB_CACHE_PERCENT, this.bdbCachePercent);
            ss.set(bdb, BdbModule.CHECKPOINT_COPY_BDBJE_LOGS, this.copyCheckpoint);
            ss.addPrimary(this.getManagerModule());
            ss.addPrimary(bdb);
        }
    }

    public File getDirectory() {
        return this.mainConfig.getParentFile();
    }

    @Override
    public void checkpoint(File dir, List<RecoverAction> actions) throws IOException {
        File config = new File(dir, "config.txt");
        FileUtils.copyFile(this.mainConfig, config);
        File sheets = new File(dir, DEFAULT_SHEETS);
        FileUtils.copyFiles(this.sheetsDir, sheets);
        actions.add(new FSMRecover(this.mainConfig.getAbsolutePath(), this.sheetsDir.getAbsolutePath()));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.mainConfig);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
        CheckpointRecovery cr;
        this.mainConfig = (File)inp.readObject();
        if (inp instanceof CheckpointRecovery) {
            cr = (CheckpointRecovery)((Object)inp);
            this.mainConfig = new File(cr.translatePath(this.mainConfig.getAbsolutePath()));
        }
        inp.defaultReadObject();
        if (inp instanceof CheckpointRecovery) {
            cr = (CheckpointRecovery)((Object)inp);
            this.sheetsDir = new File(cr.translatePath(this.sheetsDir.getAbsolutePath()));
            this.bdbDir = new File(cr.translatePath(this.bdbDir)).getAbsolutePath();
        }
        this.surtToSheetsDB = this.bdb.getDatabase("surtToSheets");
        TupleBinding stringBinding = TupleBinding.getPrimitiveBinding(String.class);
        this.surtToSheets = new StoredSortedMap(this.surtToSheetsDB, (EntryBinding)stringBinding, (EntryBinding)stringBinding, true);
    }

    @Override
    public void commit(Sheet sheet) {
        if (sheet.getSheetManager() != this) {
            throw new IllegalArgumentException();
        }
        if (!sheet.isClone()) {
            throw new IllegalArgumentException();
        }
        this.clearCloneFlag(sheet);
        this.sheets.put(sheet.getName(), sheet);
        if (sheet instanceof SingleSheet) {
            this.saveSingleSheet((SingleSheet)sheet);
        }
        this.announceChanges(sheet);
    }

    @Override
    public Set<String> getProblemSingleSheetNames() {
        return new HashSet<String>(this.problems.keySet());
    }

    @Override
    public List<PathChangeException> getSingleSheetProblems(String sheet) {
        List<PathChangeException> r = this.problems.get(sheet);
        if (r == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(r);
    }

    @Override
    public Collection<String> listContexts(String sheetName, int ofs, int len) {
        int count = 0;
        Set entries = this.surtToSheets.entrySet();
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry me : entries) {
            String surt = (String)me.getKey();
            String sheet = (String)me.getValue();
            if (!sheet.equals(sheetName) || count < ofs) continue;
            result.add(surt);
            if (result.size() > len) {
                return result;
            }
            ++count;
        }
        return result;
    }

    @Override
    public void stubCleanup() {
        this.bdb.close();
    }

    @Override
    public PathContext getPathContext() {
        return this.pathContext;
    }

    static {
        KeyManager.addKeys(FileSheetManager.class);
        LOGGER = Logger.getLogger(FileSheetManager.class.getName());
    }

    static class FSMRecover
    implements RecoverAction {
        private static final long serialVersionUID = 1L;
        private String mainConfig;
        private String sheets;

        public FSMRecover(String mainConfig, String sheets) {
            this.mainConfig = mainConfig;
            this.sheets = sheets;
        }

        public void recoverFrom(File checkpointDir, CheckpointRecovery recovery) throws Exception {
            this.mainConfig = recovery.translatePath(this.mainConfig);
            this.sheets = recovery.translatePath(this.sheets);
            File srcCfg = new File(checkpointDir, "config.txt");
            new File(this.mainConfig).getParentFile().mkdirs();
            FileUtils.copyFile(srcCfg, new File(this.mainConfig));
            File srcSheets = new File(checkpointDir, FileSheetManager.DEFAULT_SHEETS);
            FileUtils.copyFiles(srcSheets, new File(this.sheets));
        }
    }
}

