/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.file;

import com.sleepycat.util.keyrange.KeyRangeException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixFinder {
    public static int find(SortedSet<String> set, String input, List<String> result) {
        set = set.headSet(input + '\u0001');
        int opCount = 0;
        String last = PrefixFinder.last(set);
        while (last != null) {
            ++opCount;
            if (input.startsWith(last)) {
                result.add(last);
            } else {
                int p = StringUtils.indexOfDifference((String)input, (String)last);
                if (p <= 0) {
                    return opCount;
                }
                last = input.substring(0, p) + '\u0001';
            }
            try {
                set = set.headSet(last);
            }
            catch (KeyRangeException e) {
                return opCount;
            }
            last = PrefixFinder.last(set);
        }
        return opCount;
    }

    private static String last(SortedSet<String> set) {
        try {
            return set.last();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

