/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.archive.settings.file.PathChangeListener;
import org.archive.settings.file.SettingsSAXException;
import org.archive.settings.path.PathChange;
import org.archive.state.KeyTypes;
import org.archive.util.CollectionUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SettingsSAX
extends DefaultHandler {
    private static final String INDEX = "name";
    private static final String VALUE = "value";
    private static final String ROOT = "root";
    private static final String REFERENCE = "reference";
    private static final String OBJECT = "object";
    private static final String MAP = "map";
    private static final String LIST = "list";
    private static final Set<String> COMPLEX = CollectionUtils.constantSet("object", "map", "list");
    private static final String DEPENDENCIES = "dependencies";
    private Setting pending = new Setting();
    private State state = State.NORMAL;
    private String path = "";
    private final PathChangeListener listener;

    public SettingsSAX(PathChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        this.listener = listener;
    }

    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        if (qName.equals(ROOT)) {
            return;
        }
        switch (this.state) {
            case NORMAL: {
                this.handleNormal(qName, attr);
                break;
            }
            case DEP_DETECT: {
                this.handleDepDetect(qName, attr);
                break;
            }
            case DEP_STORE: {
                this.handleDepStore(qName, attr);
            }
        }
    }

    private void handleNormal(String tag, Attributes attr) throws SettingsSAXException {
        if (!this.isDataTag(tag)) {
            throw new SettingsSAXException("Invalid data tag: " + tag);
        }
        String index = attr.getValue(INDEX);
        String value = attr.getValue(VALUE);
        SettingsSAX.validate(tag, index, value);
        if (tag.equals(OBJECT)) {
            this.state = State.DEP_DETECT;
            this.pending.path = this.path = this.appendPath(index);
            this.pending.value = value;
            return;
        }
        String npath = this.appendPath(index);
        PathChange pc = new PathChange(npath, tag, value);
        this.change(pc);
        if (SettingsSAX.isComplex(tag)) {
            this.path = npath;
        }
    }

    private void handleDepDetect(String tag, Attributes attr) throws SettingsSAXException {
        if (tag.equals(DEPENDENCIES)) {
            this.state = State.DEP_STORE;
            return;
        }
        this.constructPending();
        this.handleNormal(tag, attr);
    }

    private void handleDepStore(String tag, Attributes attr) throws SettingsSAXException {
        if (!this.isDataTag(tag)) {
            throw new SettingsSAXException("Invalid data tag: " + tag);
        }
        String index = attr.getValue(INDEX);
        String value = attr.getValue(VALUE);
        SettingsSAX.validate(tag, index, value);
        this.pending.dependencies.add(new PathChange(index, tag, value));
    }

    public void endElement(String uri, String local, String tag) throws SettingsSAXException {
        if (tag.equals(ROOT)) {
            return;
        }
        if (tag.equals(DEPENDENCIES)) {
            this.constructPending();
            return;
        }
        if (tag.equals(OBJECT) && this.state != State.NORMAL) {
            this.constructPending();
        }
        if (SettingsSAX.isComplex(tag)) {
            this.truncatePath();
        }
    }

    private void constructPending() {
        PathChange pc = new PathChange(this.pending.path, OBJECT, this.pending.value);
        this.change(pc);
        this.pending.path = null;
        this.pending.value = null;
        this.pending.dependencies.clear();
        this.state = State.NORMAL;
    }

    private void truncatePath() {
        int p = this.path.lastIndexOf(46);
        this.path = p < 0 ? "" : this.path.substring(0, p);
    }

    private String appendPath(String n) {
        if (this.path.equals("")) {
            return n;
        }
        return this.path + "." + n;
    }

    private static boolean isComplex(String tag) {
        return COMPLEX.contains(tag);
    }

    private void change(PathChange pc) {
        this.listener.change(pc);
    }

    private boolean isDataTag(String tag) {
        if (COMPLEX.contains(tag)) {
            return true;
        }
        if (tag.equals(REFERENCE)) {
            return true;
        }
        Class<?> c = KeyTypes.getSimpleType(tag);
        return c != null;
    }

    private static void validate(String tag, String index, String value) throws SettingsSAXException {
        if (index == null) {
            throw new SettingsSAXException(tag + " requires a " + INDEX + " attribute.");
        }
        if (value == null) {
            throw new SettingsSAXException(tag + " requires a " + VALUE + " attribute.");
        }
    }

    public static void main(String[] args) throws Exception {
        SettingsSAX sax = new SettingsSAX(new PathChangeListener(){

            public void change(PathChange p) {
                System.out.println(p.getPath() + "=" + p.getType() + ":" + p.getValue());
            }
        });
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        String path = "testdata/selftest/AuthSelfTest/profile/sheets/default.single";
        parser.parse(new File(path), (DefaultHandler)sax);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NORMAL,
        DEP_DETECT,
        DEP_STORE;

    }

    private static class Setting {
        String path;
        String type;
        String value;
        List<PathChange> dependencies = new ArrayList<PathChange>();

        private Setting() {
        }
    }
}

