/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.file;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.archive.settings.path.PathChange;
import org.archive.util.iterator.LineReadingIterator;
import org.archive.util.iterator.TransformingIteratorWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetFileReader
extends TransformingIteratorWrapper<String, PathChange> {
    public SheetFileReader(InputStream input) {
        InputStreamReader r;
        try {
            r = new InputStreamReader(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
        BufferedReader br = new BufferedReader(r);
        this.inner = new LineReadingIterator(br);
    }

    @Override
    public PathChange transform(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        if (line.trim().equals("")) {
            return null;
        }
        int p = line.indexOf(61);
        if (p < 0) {
            throw new IllegalStateException("Invalid line: " + line);
        }
        String path = line.substring(0, p);
        String value = line.substring(p + 1);
        if ((p = value.indexOf(", ")) < 0) {
            throw new IllegalStateException("Invalid line: " + line);
        }
        String type = value.substring(0, p);
        value = value.substring(p + 2);
        return new PathChange(path, type, value);
    }
}

