/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.file;

import java.io.File;
import org.archive.settings.file.FileSheetManager;
import org.archive.settings.path.PathChange;
import org.archive.settings.path.PathChangeException;

public class Validator {
    public static int validate(String mainConfigPath) throws Exception {
        File main = new File(mainConfigPath);
        FileSheetManager fsm = new FileSheetManager(main, "unknown", false);
        int count = 0;
        for (String sheet : fsm.getProblemSingleSheetNames()) {
            for (PathChangeException pce : fsm.getSingleSheetProblems(sheet)) {
                PathChange pc = pce.getPathChange();
                System.out.print(pc.getPath());
                System.out.print("=");
                System.out.print(pc.getType());
                System.out.print(", ");
                System.out.println(pc.getValue());
                System.out.print(" # ^^^ ");
                System.out.println(pce.getMessage());
                ++count;
            }
        }
        System.out.println("There were " + count + " problems.");
        return count;
    }

    public static void main(String[] args) throws Exception {
        String mainConfigPath = args.length == 0 ? "config.txt" : args[0];
        Validator.validate(mainConfigPath);
    }
}

