/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.jmx;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.archive.settings.ModuleListener;
import org.archive.settings.SheetManager;
import org.archive.settings.jmx.LoggingDynamicMBean;
import org.archive.util.JmxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXModuleListener
implements ModuleListener,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String INSTANCE = "instance";
    private final String domain;
    private String name;
    private transient MBeanServer server;
    private final Map<Object, ObjectInfo> counts = new IdentityHashMap<Object, ObjectInfo>();

    public JMXModuleListener(String domain, String name, MBeanServer server) {
        this.domain = domain;
        this.server = server;
        this.name = name;
    }

    public void setServer(MBeanServer server, String name) {
        this.server = server;
        this.name = name;
        for (Object o : this.counts.keySet()) {
            LoggingDynamicMBean.register(server, o, this.nameOf(o));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void moduleChanged(Object old, Object newModule) {
        ObjectName toBeRemoved = null;
        boolean toBeAdded = false;
        JMXModuleListener jMXModuleListener = this;
        synchronized (jMXModuleListener) {
            ObjectInfo info;
            if (old instanceof DynamicMBean && (info = this.counts.get(old)) != null) {
                --info.count;
                toBeRemoved = info.name;
                this.counts.remove(old);
            }
            if (newModule instanceof DynamicMBean && (info = this.counts.get(newModule)) == null) {
                info = new ObjectInfo();
                DynamicMBean mbean = (DynamicMBean)newModule;
                info.name = this.nameOf(mbean);
                this.counts.put(newModule, info);
                toBeAdded = true;
            }
        }
        if (toBeRemoved != null) {
            try {
                this.server.unregisterMBean(toBeRemoved);
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (MBeanRegistrationException e) {
                throw new IllegalStateException(e);
            }
        }
        if (toBeAdded) {
            LoggingDynamicMBean.register(this.server, newModule, this.nameOf(newModule));
        }
    }

    public ObjectName nameOf(Object o) {
        return JMXModuleListener.nameOf(this.domain, this.name, o);
    }

    public static ObjectName nameOf(String domain, String name, Object o) {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = ".unknown";
        }
        String port = System.getProperty("com.sun.management.jmxremote.port");
        if (port == null) {
            port = "-1";
        }
        String type = JMXModuleListener.getRegisteredType(o);
        return JmxUtils.makeObjectName(domain, name, type, INSTANCE, String.valueOf(System.identityHashCode(o)), "host", host, "jmxport", port);
    }

    private static String getRegisteredType(Object o) {
        String type;
        if (o instanceof DynamicMBean) {
            MBeanInfo info = ((DynamicMBean)o).getMBeanInfo();
            type = info.getClassName();
        } else {
            type = o.getClass().getName();
        }
        return type;
    }

    public static String getHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return ".unknown";
        }
    }

    public static int getPort() {
        String port = System.getProperty("com.sun.management.jmxremote.port");
        try {
            return Integer.parseInt(port);
        }
        catch (RuntimeException e) {
            return -1;
        }
    }

    public static JMXModuleListener get(SheetManager mgr) {
        JMXModuleListener result = null;
        for (ModuleListener ml : mgr.getModuleListeners()) {
            if (!(ml instanceof JMXModuleListener)) continue;
            if (result != null) {
                throw new IllegalStateException("More than one JMXModuleListener.");
            }
            result = (JMXModuleListener)ml;
        }
        if (result == null) {
            throw new IllegalStateException("No JMXModuleListener.");
        }
        return result;
    }

    public Set<Object> getModules() {
        return new HashSet<Object>(this.counts.keySet());
    }

    private class ObjectInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int count;
        public ObjectName name;

        private ObjectInfo() {
        }
    }
}

