/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.jmx;

import java.util.Set;
import javax.management.openmbean.CompositeData;
import org.archive.openmbeans.annotations.Attribute;
import org.archive.openmbeans.annotations.Operation;
import org.archive.openmbeans.annotations.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface JMXSheetManager {
    public Set<String> getSheetNames();

    @Operation(desc="Removes the sheet with the given name.")
    public void removeSheet(@Parameter(name="sheetName", desc="The name of the sheet to remove.") String var1) throws IllegalArgumentException;

    @Operation(desc="Renames a sheet.")
    public void renameSheet(@Parameter(name="oldName", desc="The old name of the sheet.") String var1, @Parameter(name="newName", desc="The new name for the sheet.") String var2);

    @Operation(desc="Creates a new single sheet.", impact=1)
    public void makeSingleSheet(@Parameter(name="name", desc="The name for the new sheet") String var1);

    @Operation(desc="Returns the settings overriden by the given single sheet.", type="org.archive.settings.jmx.Types.GET_DATA_ARRAY")
    public CompositeData[] getAll(@Parameter(name="name", desc="The name of the single sheet whose overrides to return.") String var1);

    @Operation(desc="Resolves all settings defined by the given sheet.", type="org.archive.settings.jmx.Types.GET_DATA_ARRAY")
    public CompositeData[] resolveAll(@Parameter(name="name", desc="The name of the single sheet whose overrides to return.") String var1);

    @Operation(desc="Alters one or more settings in a single sheet.")
    public void setMany(@Parameter(name="sheetName", desc="The name of the single sheet whose settings to change.") String var1, @Parameter(name="clearErrors", desc="If true, the manager's list of errors for the sheet will be cleared before making the changes.  Only set to true if you're modifying the entire sheet.") boolean var2, @Parameter(name="setData", desc="An array of path/values to set.", type="org.archive.settings.jmx.Types.SET_DATA_ARRAY") CompositeData[] var3);

    @Operation(desc="Moves an element in a list up one position.")
    public void moveElementUp(@Parameter(name="sheetName", desc="The name of the sheet containing the list.") String var1, @Parameter(name="path", desc="The path to the element to move.") String var2);

    @Operation(desc="Moves an element in a list down one position.")
    public void moveElementDown(@Parameter(name="sheetName", desc="The name of the sheet containing the list.") String var1, @Parameter(name="path", desc="The path to the element to move.") String var2);

    @Attribute(desc="The names of the sheets being managed.", def="")
    public String[] getSheets();

    @Operation(desc="Sets one setting in a SingleSheet.")
    public void set(@Parameter(name="sheetName", desc="The name of the sheet whose setting to change.") String var1, @Parameter(name="path", desc="The path to the setting to change.") String var2, @Parameter(name="type", desc="The type of that setting.") String var3, @Parameter(name="value", desc="The new value for the setting at that path.") String var4);

    @Operation(desc="Returns the value of a setting as a string.")
    public String get(@Parameter(name="sheetName", desc="The name of the sheet whose setting to resolve.") String var1, @Parameter(name="path", desc="The path to the setting whose value to resolve.") String var2);

    @Operation(desc="Resolves the value of a setting.", type="org.archive.settings.jmx.Types.GET_DATA")
    public CompositeData resolve(@Parameter(name="sheetName", desc="The name of the sheet whose setting to resolve.") String var1, @Parameter(name="path", desc="The path to the setting whose value to resolve.") String var2);

    @Operation(desc="Returns true if the given sheet contains an override for the given setting.")
    public boolean contains(@Parameter(name="sheetName", desc="The name of the sheet whose setting to check.") String var1, @Parameter(name="path", desc="The path to the setting to check.") String var2);

    @Operation(desc="Associates a sheet with a SURT prefix.")
    public void associate(@Parameter(name="sheetName", desc="The name of the sheet to associate with the SURT.") String var1, @Parameter(name="surt", desc="The SURT to associate with that sheet.") String var2);

    @Operation(desc="Disassociates a SURT from a sheet.")
    public void disassociate(@Parameter(name="sheetName", desc="The name of the sheet to disassociate from the SURT.") String var1, @Parameter(name="surt", desc="The SURT to disassociate from that sheet.") String var2);

    @Operation(desc="Resolves all settings in the given sheet.")
    public String resolveAllAsString(@Parameter(name="sheetName", desc="The name of the sheet whose settings to resolve.") String var1);

    @Operation(desc="Returns only those settings that are overriden by the given sheet.")
    public String getAllAsString(@Parameter(name="sheetName", desc="The name of the sheet whose settings to resolve.") String var1);

    @Operation(desc="Checks out a sheet for editing.")
    public void checkout(@Parameter(name="sheetName", desc="The name of the sheet to check out.") String var1);

    @Operation(desc="Commits the changes made to a previously checked out sheet.")
    public void commit(@Parameter(name="sheetName", desc="The name of the sheet to commit.") String var1);

    @Operation(desc="Cancels any changes made to a checked out sheet.")
    public void cancel(@Parameter(name="sheetName", desc="The name of the sheet whose changes to cancel.") String var1);

    @Attribute(desc="The list of currently checked out sheets.", def="")
    public String[] getCheckedOutSheets();

    @Attribute(desc="Returns the list of problems encountered while loading sheets.", def="")
    public String[] getProblemSingleSheetNames();

    @Operation(desc="Returns the list of problems encountered when a sheet was loaded.", type="org.archive.settings.jmx.Types.SET_RESULT_ARRAY")
    public CompositeData[] getSingleSheetProblems(@Parameter(name="sheet", desc="The name of the sheet whose problems to return.") String var1);

    @Operation(desc="Returns the settings that will be applied for the given URI.", type="org.archive.settings.jmx.Types.GET_DATA_ARRAY")
    public CompositeData[] findConfig(@Parameter(name="uri", desc="The URI whose settings to return.") String var1);

    @Operation(desc="Returns the names of the sheets used to populate the settings for the given URI.")
    public String[] findConfigNames(@Parameter(name="uri", desc="The URI whose sheets to return.") String var1);

    @Operation(desc="Returns true if the given sheet is a single sheet, orfalse if the given sheet is a sheet bundle.  Throws an exception if the given sheet does not exist.")
    public boolean isSingleSheet(@Parameter(name="sheetName", desc="The name of the sheet to test.") String var1);

    @Attribute(desc="Returns true if the sheet manager is live.", def="false")
    public boolean isLive();

    @Operation(desc="Lists the context prefixes associated with a given sheet.")
    public String[] listContexts(@Parameter(name="sheetName", desc="The name of the sheet whose contexts to list.") String var1, @Parameter(name="start", desc="The number of contexts to skip before listing.") int var2);

    @Operation(desc="Cleans up a stub manager.")
    public void stubCleanup();

    @Operation(desc="Removes a setting from a sheet.")
    public void remove(@Parameter(name="sheetName", desc="The name of the sheet whose setting to remove.") String var1, @Parameter(name="path", desc="The path of the setting to remove.") String var2);

    @Operation(desc="Returns an absolute file path given a settings path to a FileModule.")
    public String getFilePath(@Parameter(name="setting", desc="The settings path to the FileModule.") String var1);
}

