/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.jmx;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.archive.openmbeans.annotations.Bean;
import org.archive.settings.Association;
import org.archive.settings.SettingsList;
import org.archive.settings.SettingsMap;
import org.archive.settings.Sheet;
import org.archive.settings.SheetManager;
import org.archive.settings.SingleSheet;
import org.archive.settings.Stub;
import org.archive.settings.file.FilePathListConsumer;
import org.archive.settings.jmx.JMXModuleListener;
import org.archive.settings.jmx.JMXPathListConsumer;
import org.archive.settings.jmx.JMXSheetManager;
import org.archive.settings.jmx.LoggingDynamicMBean;
import org.archive.settings.jmx.Types;
import org.archive.settings.path.ConstraintChecker;
import org.archive.settings.path.PathChange;
import org.archive.settings.path.PathChangeException;
import org.archive.settings.path.PathChanger;
import org.archive.settings.path.PathLister;
import org.archive.settings.path.PathValidator;
import org.archive.settings.path.StringPathListConsumer;
import org.archive.state.KeyTypes;
import org.archive.state.Path;
import org.archive.util.Transform;
import org.archive.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXSheetManagerImpl
extends Bean
implements Serializable,
JMXSheetManager {
    private static final Timer TIMER = new Timer(true);
    private static final long TIMEOUT = 600000L;
    public static final String DOMAIN = "org.archive";
    private static final Logger LOGGER = Logger.getLogger(JMXSheetManagerImpl.class.getName());
    private static final long serialVersionUID = 1L;
    private final SheetManager manager;
    private final Map<String, SheetAndProblems> checkedOut = new HashMap<String, SheetAndProblems>();
    private final Map<String, Map<String, PathChangeException>> problems;
    private ObjectName oname;
    private long lastUse;
    private final TimerTask reapTask;

    public JMXSheetManagerImpl(MBeanServer server, String job, String domain, SheetManager manager) {
        super(JMXSheetManager.class);
        this.manager = manager;
        this.problems = new HashMap<String, Map<String, PathChangeException>>();
        for (String s : manager.getProblemSingleSheetNames()) {
            HashMap<String, PathChangeException> sheetProblems = new HashMap<String, PathChangeException>();
            this.problems.put(s, sheetProblems);
            for (PathChangeException e : manager.getSingleSheetProblems(s)) {
                sheetProblems.put(e.getPathChange().getPath(), e);
            }
        }
        this.oname = JMXModuleListener.nameOf(domain, job, this);
        LoggingDynamicMBean.register(server, this, this.oname);
        this.lastUse = System.currentTimeMillis();
        if (manager.isLive()) {
            this.reapTask = null;
        } else {
            this.reapTask = new ReapTask(server);
            TIMER.schedule(this.reapTask, 600000L, 600000L);
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    private Sheet getSheet(String sheetName) {
        SheetAndProblems result = this.checkedOut.get(sheetName);
        if (result != null) {
            return result.sheet;
        }
        return this.manager.getSheet(sheetName);
    }

    private void stamp() {
        this.lastUse = System.currentTimeMillis();
    }

    @Override
    public synchronized Set<String> getSheetNames() {
        this.stamp();
        return this.manager.getSheetNames();
    }

    @Override
    public synchronized void removeSheet(String sheetName) throws IllegalArgumentException {
        this.stamp();
        this.manager.removeSheet(sheetName);
    }

    @Override
    public synchronized void renameSheet(String oldName, String newName) {
        this.stamp();
        this.manager.renameSheet(oldName, newName);
    }

    @Override
    public synchronized void makeSingleSheet(String name) {
        this.stamp();
        this.manager.addSingleSheet(name);
    }

    @Override
    public synchronized CompositeData[] getAll(String name) {
        this.stamp();
        SingleSheet sheet = (SingleSheet)this.getSheet(name);
        JMXPathListConsumer c = new JMXPathListConsumer();
        PathLister.getAll(sheet, c, true);
        return c.getData();
    }

    @Override
    public synchronized CompositeData[] resolveAll(String name) {
        this.stamp();
        Sheet sheet = this.getSheet(name);
        JMXPathListConsumer c = new JMXPathListConsumer();
        PathLister.resolveAll(sheet, c, false);
        return c.getData();
    }

    @Override
    public synchronized void setMany(String sheetName, boolean clearProblems, CompositeData[] setData) {
        this.stamp();
        SheetAndProblems sh = this.checkedOut.get(sheetName);
        if (sh == null) {
            throw new IllegalArgumentException(sheetName + " must be checked out before it can be edited.");
        }
        if (clearProblems) {
            sh.problems = new HashMap<String, PathChangeException>();
        }
        SingleSheet sheet = sh.sheet;
        Transformer<CompositeData, PathChange> transformer = new Transformer<CompositeData, PathChange>(){

            @Override
            public PathChange transform(CompositeData cd) {
                String type = (String)cd.get("type");
                String path = (String)cd.get("path");
                String value = (String)cd.get("value");
                return new PathChange(path, type, value);
            }
        };
        List<CompositeData> c = Arrays.asList(setData);
        Transform<CompositeData, PathChange> changes = new Transform<CompositeData, PathChange>(c, transformer);
        PathChanger pc = new PathChanger();
        Map<String, PathChangeException> sheetProblems = sh.problems;
        if (sheetProblems == null) {
            sh.problems = sheetProblems = new HashMap<String, PathChangeException>();
        }
        for (PathChange change : changes) {
            sheetProblems.remove(change.getPath());
            try {
                pc.change(sheet, change);
            }
            catch (PathChangeException e) {
                sheetProblems.put(change.getPath(), e);
            }
        }
        pc.finish(sheet);
        List<PathChangeException> list = pc.getProblems();
        ConstraintChecker plc = new ConstraintChecker(list, sheet);
        PathLister.resolveAll(sheet, plc, true);
        for (PathChangeException e : pc.getProblems()) {
            sheetProblems.put(e.getPathChange().getPath(), e);
        }
        for (PathChangeException e : list) {
            sheetProblems.put(e.getPathChange().getPath(), e);
        }
    }

    private void moveElement(String sheetName, String path, boolean up) {
        SheetAndProblems sh = this.checkedOut.get(sheetName);
        if (sh == null) {
            throw new IllegalArgumentException("Sheet must be checked out.");
        }
        SingleSheet ss = sh.sheet;
        int p = path.lastIndexOf(58);
        if (p < 0) {
            throw new IllegalArgumentException("Path does not point to a container: " + path);
        }
        String parentPath = path.substring(0, p);
        String key = path.substring(p + 1);
        Object o = PathValidator.check(ss, parentPath);
        if (o instanceof SettingsList) {
            int index = Integer.parseInt(key);
            int index2 = up ? index - 1 : index + 1;
            SettingsList list = (SettingsList)o;
            list.swap(index, index2);
        } else if (o instanceof SettingsMap) {
            ((SettingsMap)o).moveElement(key, up);
        } else {
            throw new IllegalArgumentException(parentPath + " is not a container.");
        }
    }

    @Override
    public synchronized void moveElementUp(String sheetName, String path) {
        this.stamp();
        this.moveElement(sheetName, path, true);
    }

    @Override
    public synchronized void moveElementDown(String sheetName, String path) {
        this.stamp();
        this.moveElement(sheetName, path, false);
    }

    private SingleSheet getSingleSheet(String name) {
        Sheet s = this.getSheet(name);
        if (!(s instanceof SingleSheet)) {
            throw new IllegalArgumentException(name + " is not a SingleSheet.");
        }
        return (SingleSheet)s;
    }

    public synchronized void associate(String sheetName, String[] contexts) {
        this.stamp();
        Sheet sheet = this.manager.getSheet(sheetName);
        this.manager.associate(sheet, Arrays.asList(contexts));
    }

    @Override
    public synchronized String[] getSheets() {
        this.stamp();
        Set<String> names = this.getSheetNames();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public void set(String sheet, String path, String type, String value) {
        CompositeData[] cd = new CompositeData[1];
        try {
            cd[0] = new CompositeDataSupport(Types.SET_DATA, new String[]{"path", "type", "value"}, new Object[]{path, type, value});
        }
        catch (OpenDataException e) {
            // empty catch block
        }
        this.setMany(sheet, false, cd);
    }

    @Override
    public synchronized String get(String sheetName, String path) {
        this.stamp();
        Sheet sheet = this.getSheet(sheetName);
        Object v = PathValidator.validate(sheet, path);
        if (v == null) {
            return null;
        }
        if (KeyTypes.isSimple(v.getClass())) {
            return v.toString();
        }
        return Stub.getType(v).getName();
    }

    @Override
    public synchronized boolean contains(String sheetName, String path) {
        this.stamp();
        return false;
    }

    @Override
    public synchronized CompositeData resolve(String sheetName, String path) {
        this.stamp();
        SingleSheet sheet = this.getSingleSheet(sheetName);
        final HashMap map = new HashMap();
        StringPathListConsumer plc = new StringPathListConsumer(){

            protected void consume(String path, String[] sheets, String value, String type) {
                map.put("path", path);
                map.put("sheets", sheets);
                map.put("value", value);
                map.put("type", type);
            }
        };
        try {
            return new CompositeDataSupport(Types.GET_DATA, map);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized void associate(String sheetName, String surt) {
        this.stamp();
        Sheet sheet = this.manager.getSheet(sheetName);
        this.manager.associate(sheet, Collections.singleton(surt));
    }

    @Override
    public synchronized void disassociate(String sheetName, String surt) {
        this.stamp();
        Sheet sheet = this.manager.getSheet(sheetName);
        this.manager.disassociate(sheet, Collections.singleton(surt));
    }

    @Override
    public synchronized String resolveAllAsString(String sheetName) {
        this.stamp();
        Sheet ss = this.getSheet(sheetName);
        StringWriter sw = new StringWriter();
        FilePathListConsumer c = new FilePathListConsumer(sw);
        PathLister.resolveAll(ss, c, false);
        return sw.toString();
    }

    @Override
    public synchronized String getAllAsString(String sheetName) {
        this.stamp();
        SingleSheet ss = this.getSingleSheet(sheetName);
        StringWriter sw = new StringWriter();
        FilePathListConsumer c = new FilePathListConsumer(sw);
        PathLister.getAll(ss, c, true);
        return sw.toString();
    }

    @Override
    public synchronized void checkout(String sheetName) {
        this.stamp();
        SheetAndProblems sh = new SheetAndProblems();
        sh.sheet = (SingleSheet)this.manager.checkout(sheetName);
        sh.problems = this.problems.get(sheetName);
        if (sh.problems == null) {
            sh.problems = new HashMap<String, PathChangeException>();
        }
        this.checkedOut.put(sheetName, sh);
    }

    @Override
    public synchronized void commit(String sheetName) {
        this.stamp();
        SheetAndProblems sh = this.checkedOut.remove(sheetName);
        if (sh == null) {
            throw new IllegalArgumentException("Sheet not checked out.");
        }
        SingleSheet sheet = sh.sheet;
        if (sh.problems.isEmpty()) {
            this.problems.remove(sheetName);
        } else {
            this.problems.put(sheetName, sh.problems);
        }
        this.manager.commit(sheet);
    }

    @Override
    public synchronized void cancel(String sheetName) {
        this.stamp();
        this.checkedOut.remove(sheetName);
    }

    @Override
    public synchronized String[] getCheckedOutSheets() {
        this.stamp();
        return this.checkedOut.keySet().toArray(new String[0]);
    }

    @Override
    public synchronized String[] getProblemSingleSheetNames() {
        this.stamp();
        Set<String> problems = this.problems.keySet();
        return problems.toArray(new String[problems.size()]);
    }

    @Override
    public synchronized CompositeData[] getSingleSheetProblems(String sheet) {
        this.stamp();
        SheetAndProblems sh = this.checkedOut.get(sheet);
        Map<String, PathChangeException> sheetProblems = sh == null ? this.problems.get(sheet) : sh.problems;
        ArrayList<CompositeData> result = new ArrayList<CompositeData>();
        if (sheetProblems == null) {
            return new CompositeData[0];
        }
        for (PathChangeException e : sheetProblems.values()) {
            PathChange pc = e.getPathChange();
            result.add(Types.makeSetResult(pc.getType(), pc.getPath(), pc.getValue(), e.getMessage()));
        }
        return result.toArray(new CompositeData[result.size()]);
    }

    @Override
    public synchronized CompositeData[] findConfig(String uri) {
        this.stamp();
        Sheet sheet = this.manager.findConfig(uri);
        JMXPathListConsumer c = new JMXPathListConsumer();
        PathLister.resolveAll(sheet, c, false);
        return c.getData();
    }

    @Override
    public synchronized String[] findConfigNames(String uri) {
        this.stamp();
        List<Association> surtToSheet = this.manager.findConfigNames(uri);
        String[] result = new String[surtToSheet.size() * 2];
        int i = 0;
        for (Association assoc : surtToSheet) {
            result[i] = assoc.getContext();
            result[i + 1] = assoc.getSheetName();
            i += 2;
        }
        return result;
    }

    @Override
    public synchronized boolean isSingleSheet(String sheetName) {
        this.stamp();
        Sheet sheet = this.getSheet(sheetName);
        if (sheet == null) {
            throw new IllegalArgumentException("No such sheet: " + sheetName);
        }
        return sheet instanceof SingleSheet;
    }

    private static int indexOf(List<Sheet> sheets, String name) {
        int i = 0;
        for (Sheet sheet : sheets) {
            if (sheet.getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public synchronized boolean isLive() {
        this.stamp();
        return this.manager.isLive();
    }

    @Override
    public synchronized String[] listContexts(String sheetName, int start) {
        this.stamp();
        Collection<String> c = this.manager.listContexts(sheetName, start, 100);
        return c.toArray(new String[c.size()]);
    }

    @Override
    public synchronized void stubCleanup() {
        if (this.reapTask != null) {
            this.reapTask.cancel();
        }
        this.manager.stubCleanup();
    }

    @Override
    public synchronized void remove(String sheetName, String path) {
        this.stamp();
        SingleSheet sheet = this.getSingleSheet(sheetName);
        PathChanger.remove(sheet, path);
    }

    @Override
    public synchronized String getFilePath(String settingPath) {
        SingleSheet global = this.manager.getGlobalSheet();
        Object o = PathValidator.validate(global, settingPath);
        if (o == null) {
            return null;
        }
        Path path = (Path)o;
        return path.toFile().getAbsolutePath();
    }

    public synchronized void clearErrors(String sheetName) {
        this.problems.remove(sheetName);
    }

    private static class SheetAndProblems {
        public SingleSheet sheet;
        public Map<String, PathChangeException> problems;

        private SheetAndProblems() {
        }
    }

    private class ReapTask
    extends TimerTask {
        private MBeanServer server;

        public ReapTask(MBeanServer server) {
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long now = System.currentTimeMillis();
            JMXSheetManagerImpl jMXSheetManagerImpl = JMXSheetManagerImpl.this;
            synchronized (jMXSheetManagerImpl) {
                if (!JMXSheetManagerImpl.this.checkedOut.isEmpty()) {
                    return;
                }
                if (now - JMXSheetManagerImpl.this.lastUse > 600000L) {
                    try {
                        JMXSheetManagerImpl.this.stubCleanup();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                    try {
                        this.server.unregisterMBean(JMXSheetManagerImpl.this.oname);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
        }
    }
}

