/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.jmx;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class LoggingDynamicMBean
implements DynamicMBean,
NotificationBroadcaster {
    public static final Logger LOGGER = Logger.getLogger(LoggingDynamicMBean.class.getName());
    private final DynamicMBean target;

    private LoggingDynamicMBean(DynamicMBean target) {
        this.target = target;
    }

    public static void register(MBeanServer server, Object object, ObjectName name) {
        LoggingDynamicMBean proxy = new LoggingDynamicMBean((DynamicMBean)object);
        try {
            server.registerMBean(proxy, name);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new IllegalStateException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new IllegalStateException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new IllegalStateException(e);
        }
    }

    private void dealWithException(String name, Exception e) throws ReflectionException, MBeanException {
        if (e instanceof MBeanException) {
            MBeanException me = (MBeanException)e;
            LOGGER.log(Level.SEVERE, "MBeanException during " + name, me.getTargetException());
            throw new MBeanException(new IllegalStateException(e.getMessage()));
        }
        if (e instanceof ReflectionException) {
            ReflectionException re = (ReflectionException)e;
            LOGGER.log(Level.SEVERE, "ReflectionException during " + name, re.getTargetException());
            throw new ReflectionException(new IllegalStateException(e.getMessage()));
        }
        LOGGER.log(Level.SEVERE, "UnknownException during " + name, e);
        throw new MBeanException(new IllegalStateException(e.getMessage()));
    }

    public Object getAttribute(String attr) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(this.logHeader(attr).toString());
        }
        Object result = null;
        try {
            result = this.target.getAttribute(attr);
        }
        catch (AttributeNotFoundException e) {
            LOGGER.log(Level.SEVERE, "AttributeNotFoundException during " + attr, e);
            throw new AttributeNotFoundException(e.getMessage());
        }
        catch (Exception e) {
            this.dealWithException(attr, e);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.info(this.logResult(attr, result));
        }
        return result;
    }

    public AttributeList getAttributes(String[] arg0) {
        return this.target.getAttributes(arg0);
    }

    public MBeanInfo getMBeanInfo() {
        return this.target.getMBeanInfo();
    }

    private StringBuilder logHeader(String opName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.target.getClass().getName()).append('.').append(opName);
        return sb;
    }

    private void appendObject(StringBuilder sb, Object value) {
        if (value == null) {
            sb.append(value);
        } else if (value.getClass().isArray()) {
            sb.append(Arrays.asList((Object[])value));
        } else {
            sb.append(value);
        }
    }

    private String logResult(String name, Object result) {
        StringBuilder sb = this.logHeader(name);
        sb.append(" returned ");
        this.appendObject(sb, result);
        return sb.toString();
    }

    public Object invoke(String name, Object[] params, String[] sig) throws MBeanException, ReflectionException {
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder sb = this.logHeader(name);
            sb.append('(');
            if (params.length > 0) {
                this.appendObject(sb, params[0]);
                for (int i = 1; i < params.length; ++i) {
                    sb.append(", ");
                    this.appendObject(sb, params[i]);
                }
            }
            sb.append(')');
            LOGGER.info(sb.toString());
        }
        Object result = null;
        try {
            result = this.target.invoke(name, params, sig);
        }
        catch (Exception e) {
            this.dealWithException(name, e);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(this.logResult(name, result));
        }
        return result;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder sb = this.logHeader(attr.getName());
            sb.append(" = ");
            this.appendObject(sb, attr.getValue());
            LOGGER.info(sb.toString());
        }
        try {
            this.target.setAttribute(attr);
        }
        catch (InvalidAttributeValueException e) {
            LOGGER.log(Level.SEVERE, "InvalidAttributeValueException during " + attr, e);
            throw new InvalidAttributeValueException(e.getMessage());
        }
        catch (AttributeNotFoundException e) {
            LOGGER.log(Level.SEVERE, "AttributeNotFoundException during " + attr, e);
            throw new AttributeNotFoundException(e.getMessage());
        }
        catch (Exception e) {
            this.dealWithException(attr.getName(), e);
        }
    }

    public AttributeList setAttributes(AttributeList arg0) {
        return this.target.setAttributes(arg0);
    }

    public void addNotificationListener(NotificationListener arg0, NotificationFilter arg1, Object arg2) throws IllegalArgumentException {
        ((NotificationBroadcaster)((Object)this.target)).addNotificationListener(arg0, arg1, arg2);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return ((NotificationBroadcaster)((Object)this.target)).getNotificationInfo();
    }

    public void removeNotificationListener(NotificationListener arg0) throws ListenerNotFoundException {
        ((NotificationBroadcaster)((Object)this.target)).removeNotificationListener(arg0);
    }
}

