/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.path;

import java.util.List;
import java.util.Map;
import org.archive.settings.Sheet;
import org.archive.settings.SingleSheet;
import org.archive.settings.Stub;
import org.archive.settings.path.PathChange;
import org.archive.settings.path.PathChangeException;
import org.archive.settings.path.PathValidator;
import org.archive.settings.path.StringPathListConsumer;
import org.archive.state.Constraint;
import org.archive.state.Key;
import org.archive.state.KeyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstraintChecker
extends StringPathListConsumer {
    private final List<PathChangeException> problems;
    private final SingleSheet r;
    private Constraint<?> faulty;

    public ConstraintChecker(List<PathChangeException> problems, SingleSheet r) {
        this.problems = problems;
        this.r = r;
    }

    @Override
    public void consume(String path, List<Sheet> sheet, Object value, Class type, String seenPath) {
        if (value instanceof Stub) {
            return;
        }
        int p = path.lastIndexOf(58);
        if (p < 0) {
            return;
        }
        String parentPath = path.substring(0, p);
        Object parent = PathValidator.validate(this.r, parentPath);
        if (parent instanceof List) {
            return;
        }
        if (parent instanceof Map) {
            return;
        }
        String keyName = path.substring(p + 1);
        Key<Object> key = KeyManager.getKeys(Stub.getType(parent)).get(keyName);
        for (Constraint<Object> c : key.getConstraints()) {
            if (c.allowed(value)) continue;
            this.faulty = c;
        }
        super.consume(path, sheet, value, type, seenPath);
    }

    @Override
    protected void consume(String path, String[] sheets, String value, String type) {
        if (this.faulty != null) {
            PathChangeException pce = new PathChangeException(this.faulty.description());
            pce.setPathChange(new PathChange(path, type, value));
            this.problems.add(pce);
        }
        this.faulty = null;
    }
}

