/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.path;

import java.lang.reflect.Constructor;
import org.archive.settings.Sheet;
import org.archive.settings.path.PathChangeException;
import org.archive.settings.path.PathValidator;

class Construction {
    Construction() {
    }

    private static Object getReference(Sheet sheet, String value) {
        if (value.equals("sheetManager")) {
            return sheet.getSheetManager();
        }
        return PathValidator.validate(sheet, value);
    }

    public static Object construct(Sheet sheet, String value) {
        Class<?> cls;
        if (!value.startsWith("new ")) {
            return Construction.getReference(sheet, value);
        }
        int p = (value = value.substring(4)).indexOf("(");
        if (p < 0) {
            return Construction.constructDefault(sheet, value);
        }
        String className = value.substring(0, p);
        if (!value.endsWith(")")) {
            throw new PathChangeException("Unterminated constructor.");
        }
        if ((value = value.substring(p + 1, value.length() - 1).trim()).length() == 0) {
            return Construction.constructDefault(sheet, className);
        }
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new PathChangeException(e);
        }
        String[] paths = value.split(",");
        Object[] params = new Object[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            params[i] = Construction.construct(sheet, paths[i].trim());
        }
        Constructor c = Construction.findConstructor(cls, params);
        if (c == null) {
            throw new PathChangeException("No such constructor.");
        }
        try {
            return c.newInstance(params);
        }
        catch (Exception e) {
            throw new PathChangeException(e);
        }
    }

    private static Object constructDefault(Sheet sheet, String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new PathChangeException(e);
        }
    }

    private static Constructor findConstructor(Class cls, Object[] params) {
        Constructor<?>[] all;
        for (Constructor<?> c : all = cls.getConstructors()) {
            if (!Construction.applies(c.getParameterTypes(), params)) continue;
            return c;
        }
        return null;
    }

    private static boolean applies(Class[] formal, Object[] actual) {
        if (formal.length != actual.length) {
            return false;
        }
        for (int i = 0; i < formal.length; ++i) {
            if (formal[i].isInstance(actual[i])) continue;
            return false;
        }
        return true;
    }
}

