/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.path;

public class PathChange {
    private final String path;
    private final String value;
    private final String type;

    public PathChange(String path, String type, String value) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        this.path = path;
        this.type = type;
        this.value = value;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PathChange)) {
            return false;
        }
        PathChange pc = (PathChange)other;
        return pc.type.equals(this.type) && pc.value.equals(this.value) && pc.path.equals(this.path);
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.value.hashCode() ^ this.path.hashCode();
    }

    public String toString() {
        return "PathChange{path=" + this.path + ", type=" + this.type + ", value=" + this.value + "}";
    }
}

