/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.path;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.archive.settings.SettingsList;
import org.archive.settings.SettingsMap;
import org.archive.settings.SingleSheet;
import org.archive.settings.Stub;
import org.archive.settings.path.InvalidPathException;
import org.archive.settings.path.PathChange;
import org.archive.settings.path.PathChangeException;
import org.archive.settings.path.PathValidator;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.KeyTypes;
import org.archive.state.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathChanger {
    public static final String OBJECT_TAG = "object";
    public static final String REFERENCE_TAG = "reference";
    public static final String MAP_TAG = "map";
    public static final String LIST_TAG = "list";
    public static final String PRIMARY_TAG = "primary";
    public static final String AUTO_TAG = "auto";
    public static final Object AUTO = new Object();
    private LinkedList<PendingInit> pendingInit = new LinkedList();
    private List<PathChangeException> problems = new ArrayList<PathChangeException>();

    public void change(SingleSheet ss, Iterable<PathChange> changes) {
        this.change(ss, changes.iterator());
    }

    public void change(SingleSheet ss, Iterator<PathChange> changes) {
        while (changes.hasNext()) {
            this.change(ss, changes.next());
        }
        this.finish(ss);
    }

    public List<PathChangeException> getProblems() {
        return this.problems;
    }

    public void change(SingleSheet sheet, PathChange pair) {
        if (sheet.getSheetManager().isLive()) {
            this.changeLoudly(sheet, pair);
        } else {
            this.changeQuietly(sheet, pair);
        }
    }

    private void changeQuietly(SingleSheet sheet, PathChange pair) {
        try {
            this.changeLoudly(sheet, pair);
        }
        catch (PathChangeException e) {
            e.setPathChange(pair);
            this.problems.add(e);
        }
        catch (RuntimeException e) {
            PathChangeException pce = new PathChangeException(e);
            pce.setPathChange(pair);
            this.problems.add(pce);
        }
    }

    private void changeLoudly(SingleSheet sheet, PathChange pair) {
        String path = pair.getPath();
        String typeTag = pair.getType();
        String value = pair.getValue();
        this.initIfNecessary(sheet, path);
        Object v = value == null ? null : (typeTag.equals(REFERENCE_TAG) ? this.makeReference(sheet, value) : (typeTag.equals(OBJECT_TAG) || typeTag.equals(PRIMARY_TAG) ? this.makeObject(sheet, pair) : (typeTag.equals(MAP_TAG) ? this.makeMap(sheet, pair) : (typeTag.equals(LIST_TAG) ? this.makeList(sheet, pair) : (typeTag.equals(AUTO_TAG) ? AUTO : this.makeSimple(sheet, typeTag, value))))));
        this.finish(sheet, path, v);
    }

    public void finish(SingleSheet sheet) {
        this.initIfNecessary(sheet, String.valueOf(':'));
    }

    private void initIfNecessary(SingleSheet sheet, String currentPath) {
        while (!this.pendingInit.isEmpty()) {
            PendingInit pi = this.pendingInit.getFirst();
            if (currentPath.startsWith(pi.path)) {
                return;
            }
            this.pendingInit.removeFirst();
            pi.module.initialTasks(sheet);
        }
    }

    private Object makeReference(SingleSheet sheet, String value) {
        return PathValidator.validate(sheet, value);
    }

    private Object makeSimple(SingleSheet sheet, String typeTag, String value) {
        if (typeTag.equals("file")) {
            return new Path(sheet.getSheetManager().getPathContext(), value);
        }
        Class<?> type = KeyTypes.getSimpleType(typeTag);
        try {
            return KeyTypes.fromString(type, value);
        }
        catch (Exception e) {
            throw new PathChangeException(e);
        }
    }

    private Object getPreexistingObject(SingleSheet sheet, PathChange pc) {
        try {
            Object o = PathValidator.check(sheet, pc.getPath());
            if (o == null) {
                return null;
            }
            Class otype = Stub.getType(o);
            if (otype.getName().equals(pc.getValue())) {
                return o;
            }
            return null;
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    private Object getPreexistingCol(SingleSheet sheet, PathChange pc) {
        try {
            Object o = PathValidator.check(sheet, pc.getPath());
            if (pc.getType().equals(MAP_TAG)) {
                if (!(o instanceof SettingsMap)) {
                    return null;
                }
                SettingsMap sm = (SettingsMap)o;
                if (sm.getElementType().getName().equals(pc.getValue())) {
                    return sm;
                }
            } else if (pc.getType().equals(LIST_TAG)) {
                if (!(o instanceof SettingsList)) {
                    return null;
                }
                SettingsList sm = (SettingsList)o;
                if (sm.getElementType().getName().equals(pc.getValue())) {
                    return sm;
                }
            }
            return null;
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    private Object makeObject(SingleSheet sheet, PathChange pc) {
        Object pre = this.getPreexistingObject(sheet, pc);
        if (pre != null) {
            if (sheet.isGlobal()) {
                if (pc.getType().equals(OBJECT_TAG)) {
                    sheet.removePrimary(pre);
                } else {
                    sheet.addPrimary(pre);
                }
            }
            return pre;
        }
        Object result = this.makeObject2(sheet, pc);
        if (result instanceof Initializable) {
            PendingInit pi = new PendingInit();
            pi.path = pc.getPath();
            pi.module = (Initializable)result;
            this.pendingInit.addFirst(pi);
        }
        return result;
    }

    private Object makeObject2(SingleSheet sheet, PathChange pc) {
        String value = pc.getValue();
        if (value.equals("null")) {
            return null;
        }
        try {
            Class<?> c = Class.forName(value);
            Stub<?> result = !this.isLive(sheet, c) ? Stub.make(c) : c.newInstance();
            if (sheet.isGlobal()) {
                if (pc.getType().equals(PRIMARY_TAG)) {
                    sheet.addPrimary(result);
                } else {
                    sheet.removePrimary(result);
                }
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new PathChangeException("No such class: " + value);
        }
        catch (InstantiationException e) {
            throw new PathChangeException(e);
        }
        catch (IllegalAccessException e) {
            throw new PathChangeException(e);
        }
    }

    private Object makeList(SingleSheet sheet, PathChange pc) {
        Object pre = this.getPreexistingCol(sheet, pc);
        if (pre != null) {
            return pre;
        }
        String value = pc.getValue();
        try {
            Class<?> c = Class.forName(value);
            SettingsList r = new SettingsList(sheet, c);
            return r;
        }
        catch (ClassNotFoundException e) {
            throw new PathChangeException("No such class: " + value);
        }
    }

    private Object makeMap(SingleSheet sheet, PathChange pc) {
        Object pre = this.getPreexistingCol(sheet, pc);
        if (pre != null) {
            return pre;
        }
        String value = pc.getValue();
        try {
            Class<?> c = Class.forName(value);
            SettingsMap r = new SettingsMap(sheet, c);
            return r;
        }
        catch (ClassNotFoundException e) {
            throw new PathChangeException("No such class: " + value);
        }
    }

    private boolean isLive(SingleSheet sheet, Class c) {
        if (Map.class.isAssignableFrom(c)) {
            return true;
        }
        if (List.class.isAssignableFrom(c)) {
            return true;
        }
        return sheet.getSheetManager().isLive();
    }

    private void finish(SingleSheet sheet, String path, Object value) {
        Object previous;
        String lastToken;
        String previousPath;
        int p = path.lastIndexOf(58);
        if (p < 0) {
            previousPath = "";
            lastToken = path;
            previous = sheet.getSheetManager().getManagerModule();
        } else {
            previousPath = path.substring(0, p);
            lastToken = path.substring(p + 1);
            previous = PathValidator.validate(sheet, previousPath);
        }
        if (previous instanceof List) {
            int index;
            if (value == AUTO) {
                throw new PathChangeException("Can't autowire list elements.");
            }
            try {
                index = Integer.parseInt(lastToken);
            }
            catch (NumberFormatException e) {
                throw new PathChangeException(e);
            }
            List mergedList = (List)previous;
            previous = PathValidator.check(sheet, previousPath);
            List editableList = (List)previous;
            int adjustedIndex = index - mergedList.size() + editableList.size();
            if (adjustedIndex < 0) {
                throw new PathChangeException("Index of " + index + " modifies global sheet, not " + sheet);
            }
            if (adjustedIndex < editableList.size()) {
                editableList.set(adjustedIndex, value);
            } else if (adjustedIndex == editableList.size()) {
                editableList.add(value);
            } else {
                throw new PathChangeException("Incorrect index: " + path + " (expected " + mergedList.size() + ")");
            }
            return;
        }
        if (previous instanceof Map) {
            if (value == AUTO) {
                throw new PathChangeException("Can't autowire map elements.");
            }
            previous = PathValidator.check(sheet, previousPath);
            Map map = (Map)previous;
            map.put(lastToken, value);
            return;
        }
        if (previous == null) {
            throw new PathChangeException("Can't change '" + path + "' because '" + previousPath + "' resolves to null.");
        }
        Class prevType = Stub.getType(previous);
        Map<String, Key<Object>> keys = KeyManager.getKeys(prevType);
        Key<Object> key = keys.get(lastToken);
        if (key == null) {
            throw new PathChangeException("No such key: " + path);
        }
        if (value == AUTO) {
            value = sheet.findPrimary(key.getType());
        }
        if (value instanceof Stub) {
            sheet.setStub((Stub)previous, key, (Stub)value);
        } else {
            sheet.set(previous, key, value);
        }
    }

    public static void remove(SingleSheet sheet, String path) {
        int p = path.lastIndexOf(58);
        if (p < 0) {
            throw new IllegalArgumentException("Can't remove " + path);
        }
        String parentPath = path.substring(0, p);
        String lastToken = path.substring(p + 1);
        Object parent = PathValidator.validate(sheet, parentPath);
        if (parent instanceof Map) {
            parent = PathValidator.check(sheet, parentPath);
            ((Map)parent).remove(lastToken);
            return;
        }
        if (parent instanceof List) {
            List mergedList = (List)parent;
            parent = PathValidator.check(sheet, parentPath);
            List editableList = (List)parent;
            int index = Integer.parseInt(lastToken);
            int adjustedIndex = index - mergedList.size() + editableList.size();
            if (adjustedIndex < 0) {
                throw new PathChangeException("Index of " + index + " modifies global sheet, not " + sheet);
            }
            editableList.remove(adjustedIndex);
            return;
        }
        Class type = Stub.getType(parent);
        Map<String, Key<Object>> keys = KeyManager.getKeys(type);
        Key<Object> key = keys.get(lastToken);
        if (key == null) {
            throw new IllegalArgumentException("No such path: " + path);
        }
        sheet.remove(parent, key);
    }

    public static boolean isObjectTag(String tag) {
        return tag.equals(OBJECT_TAG) || tag.equals(PRIMARY_TAG) || tag.equals(REFERENCE_TAG) || tag.equals(AUTO_TAG);
    }

    public static boolean isCreateTag(String tag) {
        return tag.equals(OBJECT_TAG) || tag.equals(PRIMARY_TAG);
    }

    public static boolean isReuseTag(String tag) {
        return tag.equals(AUTO_TAG) || tag.equals(REFERENCE_TAG);
    }

    private static class PendingInit {
        Initializable module;
        String path;

        private PendingInit() {
        }
    }
}

