/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.path;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.archive.settings.Resolved;
import org.archive.settings.Sheet;
import org.archive.settings.SheetManager;
import org.archive.settings.SingleSheet;
import org.archive.settings.Stub;
import org.archive.settings.TypedList;
import org.archive.settings.TypedMap;
import org.archive.settings.path.PathListConsumer;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.KeyTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathLister {
    private final Sheet startSheet;
    private final PathListConsumer consumer;
    private final boolean resolve;
    private final IdentityHashMap<Object, String> alreadySeen;
    private final boolean rootOnly;

    private PathLister(Sheet sheet, PathListConsumer c, boolean resolve, boolean rootOnly) {
        this.startSheet = sheet;
        this.resolve = resolve;
        this.consumer = c;
        this.alreadySeen = new IdentityHashMap();
        this.rootOnly = rootOnly;
    }

    private void list() {
        Key<Object> k;
        Object start = this.startSheet.getSheetManager().getManagerModule();
        Class type = Stub.getType(start);
        if (!this.rootOnly) {
            SingleSheet global = this.startSheet.getSheetManager().getGlobalSheet();
            List<Sheet> globalList = Collections.singletonList(global);
            this.consume("manager", globalList, start, type);
            this.alreadySeen.put(start, SheetManager.MANAGER.getFieldName());
            Collection<Key<Object>> keys = KeyManager.getKeys(type).values();
            for (Key<Object> k2 : keys) {
                Key<Object> ref = k2;
                if (ref == SheetManager.ROOT) continue;
                this.handleKey("", start, k2);
            }
        } else {
            Collection<Key<Object>> keys = KeyManager.getKeys(type).values();
            for (Key<Object> k3 : keys) {
                SingleSheet global = this.startSheet.getSheetManager().getGlobalSheet();
                Key<Object> ref = k3;
                if (ref == SheetManager.ROOT) continue;
                Object v = this.startSheet.getSheetManager().isLive() ? global.get(start, k3) : ((Sheet)global).resolve(start, k3).getValue();
                this.alreadySeen.put(v, k3.getFieldName());
            }
        }
        Key<Object> k2 = k = SheetManager.ROOT;
        this.handleKey("", start, k2);
    }

    public static void resolveAll(Sheet sheet, PathListConsumer consumer, boolean rootOnly) {
        new PathLister(sheet, consumer, true, rootOnly).list();
    }

    public static void getAll(SingleSheet sheet, PathListConsumer consumer, boolean rootOnly) {
        new PathLister(sheet, consumer, false, rootOnly).list();
    }

    private void handleModule(String path, Object module) {
        if (module == null) {
            return;
        }
        if (this.alreadySeen(module, path)) {
            return;
        }
        Class<Object> ptype = module instanceof Stub ? ((Stub)module).getType() : module.getClass();
        Collection<Key<Object>> declared = KeyManager.getKeys(ptype).values();
        for (Key<Object> k : declared) {
            this.handleKey(path, module, k);
        }
    }

    private void handleKey(String path, Object processor, Key<Object> k) {
        Resolved<Object> r = this.startSheet.resolve(processor, k);
        List<Sheet> resolvedList = r.getSheets();
        String kpath = PathLister.appendPath(path, k.getFieldName());
        this.consume(kpath, resolvedList, r.getValue(), k.getType());
        if (Map.class.isAssignableFrom(k.getType())) {
            this.handleMap(kpath, r.getValue());
        } else if (List.class.isAssignableFrom(k.getType())) {
            this.handleList(kpath, r.getValue());
        } else {
            this.handleModule(kpath, r.getValue());
        }
    }

    private void consume(String path, List<Sheet> list, Object value, Class type) {
        String seen = this.alreadySeen.get(value);
        Sheet first = list.get(0);
        if (this.resolve || first == this.startSheet) {
            this.consumer.consume(path, list, value, type, seen);
        }
    }

    private void advance(String path, List<Sheet> list, Object value) {
        if (value instanceof TypedList) {
            this.handleList(path, value);
        } else if (value instanceof TypedMap) {
            this.handleMap(path, value);
        } else {
            this.handleModule(path, value);
        }
    }

    private void handleList(String path, Object l) {
        if (this.alreadySeen(l, path)) {
            return;
        }
        TypedList list = (TypedList)l;
        for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            String lpath = PathLister.appendPath(path, Integer.toString(i));
            List<Sheet> sheets = list.getSheets(i);
            this.consume(lpath, sheets, element, list.getElementType());
            this.advance(lpath, sheets, element);
        }
    }

    private void handleMap(String path, Object m) {
        if (this.alreadySeen(m, path)) {
            return;
        }
        TypedMap map = (TypedMap)m;
        for (Map.Entry entry : map.entrySet()) {
            Object element = entry.getValue();
            String entryKey = (String)entry.getKey();
            String mpath = PathLister.appendPath(path, entryKey);
            List<Sheet> sheets = map.getSheets(entryKey);
            this.consume(mpath, sheets, element, map.getElementType());
            this.advance(mpath, sheets, element);
        }
    }

    private static String appendPath(String path, String next) {
        if (path.length() == 0) {
            return next;
        }
        return path + ':' + next;
    }

    private boolean alreadySeen(Object v, String path) {
        if (v == null) {
            return false;
        }
        if (KeyTypes.isSimple(Stub.getType(v))) {
            return false;
        }
        if (this.alreadySeen.containsKey(v)) {
            return true;
        }
        this.alreadySeen.put(v, path);
        return false;
    }
}

