/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.path;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.archive.settings.Sheet;
import org.archive.settings.SingleSheet;
import org.archive.settings.Stub;
import org.archive.settings.path.InvalidPathException;
import org.archive.state.Key;
import org.archive.state.KeyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathValidator {
    public static final char DELIMITER = ':';
    private final Sheet sheet;
    private final String path;
    private StringBuilder subPath;
    private List<String> tokens;
    private final boolean checkLast;

    private PathValidator(Sheet sheet, String path, boolean checkLast) {
        if (sheet == null) {
            throw new IllegalArgumentException("sheet must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        this.sheet = sheet;
        this.path = path;
        this.subPath = new StringBuilder();
        this.tokens = new LinkedList<String>(Arrays.asList(path.split("\\:")));
        this.checkLast = checkLast;
    }

    private Object validatePath() {
        String first = this.tokens.get(0);
        this.advance();
        Object manager = this.sheet.getSheetManager().getManagerModule();
        Object current = this.validateKey(manager, first);
        while (!this.tokens.isEmpty()) {
            String n = this.tokens.get(0);
            if (current instanceof Map) {
                Map map = (Map)current;
                current = this.validateMap(map, n);
            } else if (current instanceof List) {
                List list = (List)current;
                current = this.validateList(list, n);
            } else {
                current = this.validateKey(current, n);
            }
            this.advance();
        }
        return current;
    }

    private void advance() {
        if (this.subPath.length() > 0) {
            this.subPath.append(':');
        }
        this.subPath.append(this.tokens.get(0));
        this.tokens.remove(0);
    }

    private RuntimeException ex(String msg) {
        String e = this.path + " " + msg + this.subPath;
        return new InvalidPathException(e);
    }

    private Object validateList(List<Object> current, String indexString) {
        int index;
        try {
            index = Integer.parseInt(indexString);
        }
        catch (NumberFormatException e) {
            throw this.ex(" has non-integer index at ");
        }
        try {
            return current.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.ex(" has out-of-bounds index at ");
        }
    }

    private Object validateMap(Map<String, Object> current, String keyString) {
        Object r = current.get(keyString);
        return r;
    }

    private Object validateKey(Object current, String keyName) {
        if (current == null) {
            throw this.ex(" has null pointer at ");
        }
        Class<Object> c = current instanceof Stub ? ((Stub)current).getType() : current.getClass();
        Key<Object> key = KeyManager.getKeys(c).get(keyName);
        if (key == null) {
            throw new InvalidPathException(this.path + " is invalid because " + c.getName() + " does not define a key named " + keyName);
        }
        return this.resolve(current, key);
    }

    public static Object validate(Sheet sheet, String path) {
        return new PathValidator(sheet, path, false).validatePath();
    }

    public static Object check(SingleSheet sheet, String path) {
        return new PathValidator(sheet, path, true).validatePath();
    }

    private Object resolve(Object current, Key<Object> key) {
        if (this.checkLast && this.tokens.size() <= 1) {
            Class<Object> type = key.getType();
            if (Map.class.isAssignableFrom(type)) {
                SingleSheet ss = (SingleSheet)this.sheet;
                Key<Object> k = key;
                Map r = ss.resolveEditableMap(current, k);
                if (r == null) {
                    throw this.ex(" alters a key for a nonexistent map at ");
                }
                return r;
            }
            if (List.class.isAssignableFrom(type)) {
                SingleSheet ss = (SingleSheet)this.sheet;
                List r = ss.resolveEditableList(current, key.cast(List.class));
                if (r == null) {
                    throw this.ex(" alters an element for nonexistent list at ");
                }
                return r;
            }
        }
        return this.sheet.resolve(current, key).getValue();
    }
}

