/*
 * Decompiled with CFR 0.152.
 */
package org.archive.settings.path;

import java.util.List;
import java.util.Map;
import org.archive.settings.Sheet;
import org.archive.settings.SingleSheet;
import org.archive.settings.Stub;
import org.archive.settings.TypedList;
import org.archive.settings.TypedMap;
import org.archive.settings.path.PathListConsumer;
import org.archive.state.KeyTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringPathListConsumer
implements PathListConsumer {
    @Override
    public void consume(String path, List<Sheet> sheets, Object value, Class type, String seenPath) {
        String v;
        String typeTag;
        Class<?> actual;
        Sheet last = sheets.get(sheets.size() - 1);
        boolean primary = last instanceof SingleSheet && ((SingleSheet)last).isGlobal() ? ((SingleSheet)last).isPrimary(value) : last.getSheetManager().getGlobalSheet().isPrimary(value);
        String[] snames = new String[sheets.size()];
        for (int i = 0; i < snames.length; ++i) {
            snames[i] = sheets.get(i).getName();
        }
        Class<?> clazz = actual = value == null ? type : value.getClass();
        if (KeyTypes.isSimple(type)) {
            typeTag = KeyTypes.getSimpleTypeTag(type);
            v = KeyTypes.toString(value);
        } else if (seenPath != null) {
            typeTag = primary ? "auto" : "reference";
            v = seenPath;
        } else if (Map.class.isAssignableFrom(actual)) {
            typeTag = "map";
            v = ((TypedMap)value).getElementType().getName();
        } else if (List.class.isAssignableFrom(actual)) {
            typeTag = "list";
            v = ((TypedList)value).getElementType().getName();
        } else {
            typeTag = primary ? "primary" : "object";
            v = value == null ? "null" : Stub.getType(value).getName();
        }
        this.consume(path, snames, v, typeTag);
    }

    protected abstract void consume(String var1, String[] var2, String var3, String var4);
}

