/*
 * Decompiled with CFR 0.152.
 */
package org.archive.state;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.archive.settings.CheckpointRecovery;
import org.archive.state.PathContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPathContext
implements PathContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private File baseDir;
    private Map<String, String> variables;

    public DefaultPathContext(File baseDir, Map<String, String> vars) {
        this.baseDir = baseDir;
        this.variables = Collections.unmodifiableMap(vars);
    }

    public DefaultPathContext(File baseDir) {
        this(baseDir, Collections.emptyMap());
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public Map<String, String> getPathVariables() {
        return this.variables;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
        inp.defaultReadObject();
        if (inp instanceof CheckpointRecovery) {
            CheckpointRecovery cr = (CheckpointRecovery)((Object)inp);
            this.baseDir = new File(cr.translatePath(this.baseDir.getAbsolutePath()));
        }
    }
}

