/*
 * Decompiled with CFR 0.152.
 */
package org.archive.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.archive.state.Constraint;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyTypes;
import org.archive.state.StateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleStateProvider
implements StateProvider {
    private Map<Object, Map<Key, Object>> values = new IdentityHashMap<Object, Map<Key, Object>>();

    @Override
    public <T> T get(Object module, Key<T> key) {
        if (module == null) {
            throw new IllegalArgumentException("Null module.");
        }
        Class<?> owner = key.getOwner();
        if (!owner.isInstance(module)) {
            throw new IllegalArgumentException("Module and key incompatible.");
        }
        Map<Key, Object> map = this.values.get(module);
        Object o = null;
        if (map != null) {
            o = map.get(key);
        }
        if (o != null) {
            return key.getType().cast(o);
        }
        Class<T> type = key.getType();
        if (KeyTypes.isSimple(type)) {
            return key.getDefaultValue();
        }
        if (type == List.class) {
            if (KeyTypes.isSimple(key.getElementType())) {
                return key.getDefaultValue();
            }
            List<Class<?>> clist = key.getDefaultListElementImplementations();
            ArrayList<Object> list = new ArrayList<Object>();
            for (Class<?> c : clist) {
                list.add(this.create(c));
            }
            return type.cast(list);
        }
        if (type == Map.class) {
            if (KeyTypes.isSimple(key.getElementType())) {
                return key.getDefaultValue();
            }
            Map<String, Class<?>> cm = key.getDefaultMapElementImplementations();
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Class<?>> me : cm.entrySet()) {
                m.put(me.getKey(), this.create(me.getValue()));
            }
            return type.cast(m);
        }
        return type.cast(this.create(key.getDefaultImplementation()));
    }

    private Object create(Class<?> c) {
        if (c == null) {
            return null;
        }
        try {
            Object o = c.newInstance();
            if (o instanceof Initializable) {
                ((Initializable)o).initialTasks(this);
            }
            return o;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> void set(Object module, Key<T> key, T value) {
        if (module == null) {
            throw new IllegalArgumentException("Null module.");
        }
        Class<?> owner = key.getOwner();
        if (!owner.isInstance(module)) {
            throw new IllegalArgumentException("Module and key incompatible.");
        }
        for (Constraint<T> c : key.getConstraints()) {
            if (c.allowed(value)) continue;
            throw new IllegalArgumentException();
        }
        Map<Key, Object> map = this.values.get(module);
        if (map == null) {
            map = new HashMap<Key, Object>();
            this.values.put(module, map);
        }
        map.put(key, value);
    }
}

