/*
 * Decompiled with CFR 0.152.
 */
package org.archive.state;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.archive.i18n.LocaleCache;
import org.archive.state.Constraint;
import org.archive.state.Expert;
import org.archive.state.Global;
import org.archive.state.Immutable;
import org.archive.state.KeyMaker;
import org.archive.state.KeyManager;
import org.archive.state.KeyTypes;
import org.archive.state.NonNullConstraint;
import org.archive.state.Nullable;
import org.archive.state.Path;
import org.archive.state.UnregisteredKeyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Key<Value>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fieldName;
    private Class<?> owner;
    private final transient Class<Value> type;
    private Class<?> elementType;
    private final transient Object def;
    private transient Set<Constraint<Value>> constraints;
    private transient boolean expert;
    private transient boolean global;
    private transient boolean immutable;
    private final boolean autoDetect;
    private boolean initialized;
    private String guessedOwner;

    public Key(KeyMaker<Value> maker) {
        maker.validate();
        this.guessedOwner = Key.guessDeclaringClass();
        this.type = maker.type;
        this.elementType = maker.elementType;
        this.def = maker.def;
        this.autoDetect = maker.autoDetect;
        HashSet s = new HashSet(maker.constraints);
        this.constraints = Collections.unmodifiableSet(s);
        maker.reset();
    }

    private void checkInit() {
        if (this.initialized) {
            return;
        }
        if (this.guessedOwner == null) {
            throw new UnregisteredKeyException("Unregistered key");
        }
        throw new UnregisteredKeyException("Unregistered key in class " + this.guessedOwner + "; you must invoke KeyManager.addKeys(" + this.guessedOwner + ".class); in its static initializer.");
    }

    void setMetadata(Class<?> owner, Field field) {
        this.initialized = true;
        this.fieldName = field.getName().toLowerCase().replace('_', '-');
        this.owner = owner;
        if (field.getAnnotation(Nullable.class) == null) {
            this.addNonNullConstraint();
        } else {
            if (KeyTypes.isSimple(this.type)) {
                throw new IllegalStateException(owner.getName() + "." + this.fieldName + " uses @Nullable but has a simple type.");
            }
            if (this.type == List.class) {
                throw new IllegalStateException(owner.getName() + "." + this.fieldName + " uses @Nullable but has a list type.");
            }
            if (this.type == Map.class) {
                throw new IllegalStateException(owner.getName() + "." + this.fieldName + " uses @Nullable but has a map type.");
            }
        }
        if (field.getAnnotation(Expert.class) != null) {
            this.expert = true;
        }
        if (field.getAnnotation(Global.class) != null) {
            this.global = true;
        }
        if (field.getAnnotation(Immutable.class) != null) {
            this.global = true;
            this.immutable = true;
        }
    }

    private void addNonNullConstraint() {
        HashSet<Constraint<Value>> s = new HashSet<Constraint<Value>>(this.constraints);
        s.add(NonNullConstraint.INSTANCE);
        this.constraints = Collections.unmodifiableSet(s);
    }

    public Class<?> getElementType() {
        this.checkInit();
        return this.elementType;
    }

    public boolean isExpert() {
        this.checkInit();
        return this.expert;
    }

    public boolean isGlobal() {
        this.checkInit();
        return this.global;
    }

    public boolean isImmutable() {
        this.checkInit();
        return this.immutable;
    }

    public boolean isAutoDetected() {
        this.checkInit();
        return this.autoDetect;
    }

    public String getFieldName() {
        this.checkInit();
        return this.fieldName;
    }

    public String getName(Locale locale) {
        this.checkInit();
        String result = LocaleCache.load(this.owner, locale).get(this.fieldName + "-name");
        return result == null ? this.fieldName.replace('_', '-') : result;
    }

    public String getDescription(Locale locale) {
        this.checkInit();
        return LocaleCache.load(this.owner, locale).get(this.fieldName + "-description");
    }

    public Class<?> getOwner() {
        this.checkInit();
        return this.owner;
    }

    public Class<Value> getType() {
        this.checkInit();
        return this.type;
    }

    public Set<Constraint<Value>> getConstraints() {
        this.checkInit();
        return this.constraints;
    }

    public Value getDefaultValue() {
        this.checkInit();
        if (KeyTypes.isSimple(this.type)) {
            return this.type.cast(this.def);
        }
        if (this.elementType == null) {
            return null;
        }
        if (KeyTypes.isSimple(this.elementType)) {
            return this.type.cast(this.def);
        }
        return null;
    }

    public Class<? extends Value> getDefaultImplementation() {
        if (KeyTypes.isSimple(this.type)) {
            return null;
        }
        if (this.type == Map.class) {
            return null;
        }
        if (this.type == List.class) {
            return null;
        }
        return (Class)this.def;
    }

    public List<Class<?>> getDefaultListElementImplementations() {
        if (this.type != List.class) {
            return null;
        }
        return (List)this.def;
    }

    public Map<String, Class<?>> getDefaultMapElementImplementations() {
        if (this.type != Map.class) {
            return null;
        }
        return (Map)this.def;
    }

    public String toString() {
        return this.fieldName;
    }

    public static Key<String> make(String def) {
        return KeyMaker.make(def).toKey();
    }

    public static Key<Boolean> make(boolean def) {
        return KeyMaker.make(def).toKey();
    }

    public static Key<Byte> make(byte def) {
        return KeyMaker.make(def).toKey();
    }

    public static Key<Character> make(char def) {
        return KeyMaker.make(Character.valueOf(def)).toKey();
    }

    public static Key<Double> make(double def) {
        return KeyMaker.make(def).toKey();
    }

    public static Key<Float> make(float def) {
        return KeyMaker.make(Float.valueOf(def)).toKey();
    }

    public static Key<Integer> make(int def) {
        return KeyMaker.make(def).toKey();
    }

    public static Key<Long> make(long def) {
        return KeyMaker.make(def).toKey();
    }

    public static Key<Short> make(short def) {
        return KeyMaker.make(def).toKey();
    }

    public static Key<Path> make(Path def) {
        return KeyMaker.make(def).toKey();
    }

    public static Key<BigInteger> make(BigInteger def) {
        return KeyMaker.make(def).toKey();
    }

    public static Key<BigDecimal> make(BigDecimal def) {
        return KeyMaker.make(def).toKey();
    }

    public static Key<Pattern> make(Pattern def) {
        return KeyMaker.make(def).toKey();
    }

    public static <T extends Enum> Key<T> make(T def) {
        return KeyMaker.make(def).toKey();
    }

    public static <X> Key<X> make(Class<X> type, Class<? extends X> def) {
        KeyMaker<X> result = KeyMaker.make(type, def);
        return result.toKey();
    }

    public static <X> Key<X> makeAuto(Class<X> type) {
        KeyMaker<X> result = KeyMaker.makeAuto(type);
        return result.toKey();
    }

    public static <X> Key<List<X>> makeList(Class<X> element) {
        KeyMaker<List<X>> km = KeyMaker.makeList(element);
        return new Key<List<X>>(km);
    }

    public static <X> Key<List<X>> makeSimpleList(Class<X> element, X ... def) {
        return KeyMaker.makeSimpleList(element, def).toKey();
    }

    public static <X> Key<List<X>> makeModuleList(Class<X> element, Class<? extends X> ... def) {
        return KeyMaker.makeModuleList(element, def).toKey();
    }

    public static <X> Key<Map<String, X>> makeMap(Class<X> value) {
        KeyMaker<Map<String, X>> km = KeyMaker.makeMap(value);
        return new Key<Map<String, X>>(km);
    }

    public static <X> Key<X> makeNull(Class<X> cls) {
        return KeyMaker.makeNull(cls).toKey();
    }

    private Object readResolve() {
        return KeyManager.getKeys(this.owner).get(this.fieldName);
    }

    public <T> Key<T> cast(Class<T> cls) {
        if (cls != this.type) {
            throw new ClassCastException("Can't cast Key<" + this.type.getClass().getName() + "> to Key<" + cls.getClass().getName() + ">");
        }
        Key r = this;
        return r;
    }

    private static String guessDeclaringClass() {
        try {
            StackTraceElement[] stack;
            for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
                if (!element.getMethodName().equals("<clinit>")) continue;
                return element.getClassName();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

