/*
 * Decompiled with CFR 0.152.
 */
package org.archive.state;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.archive.state.Constraint;
import org.archive.state.Key;
import org.archive.state.KeyTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyMaker<T> {
    Class<T> type;
    Set<Constraint<T>> constraints = new HashSet<Constraint<T>>();
    Object def;
    Class<?> elementType;
    boolean autoDetect;

    public void reset() {
        this.type = null;
        this.constraints.clear();
        this.def = null;
    }

    void validate() {
    }

    public KeyMaker<T> addConstraint(Constraint<T> c) {
        this.constraints.add(c);
        return this;
    }

    public Key<T> toKey() {
        return new Key(this);
    }

    public static <T> KeyMaker<T> make(T def) {
        Class<?> c = def.getClass();
        if (!KeyTypes.isSimple(c)) {
            throw new IllegalArgumentException("Supplied actual object default value for a non-simple Key.  Supply the Class of an implementation of " + c.getName() + " instead.");
        }
        KeyMaker<T> result = new KeyMaker<T>();
        result.type = c;
        result.def = def;
        return result;
    }

    public static <T> KeyMaker<T> make(Class<T> type, Class<? extends T> defClass) {
        if (KeyTypes.isSimple(type)) {
            throw new IllegalArgumentException("Supplied implementation class for a simple Key. Supply the actual default object instead.");
        }
        KeyMaker<T> result = new KeyMaker<T>();
        result.type = type;
        result.def = defClass;
        return result;
    }

    public static <T> KeyMaker<List<T>> makeList(Class<T> element) {
        Class<List> c;
        Class<List> c2 = c = List.class;
        KeyMaker<List<T>> r = new KeyMaker<List<T>>();
        r.type = c2;
        r.elementType = element;
        List empty = Collections.EMPTY_LIST;
        r.def = empty;
        return r;
    }

    public static <T> KeyMaker<List<T>> makeSimpleList(Class<T> element, T ... def) {
        if (!KeyTypes.isSimple(element)) {
            throw new IllegalArgumentException("Can't provide instances for List with module element type.  Use makeModuleList instead.");
        }
        KeyMaker<List<T>> r = new KeyMaker<List<T>>();
        r.type = List.class;
        r.elementType = element;
        r.def = Arrays.asList(def);
        return r;
    }

    public static <T> KeyMaker<List<T>> makeModuleList(Class<T> element, Class<? extends T> ... def) {
        if (KeyTypes.isSimple(element)) {
            throw new IllegalArgumentException("Can't provide implementation classes for List with simple element type.  Use makeSimpleList instead.");
        }
        KeyMaker<List<T>> r = new KeyMaker<List<T>>();
        r.type = List.class;
        r.elementType = element;
        r.def = Arrays.asList(def);
        return r;
    }

    public static <T> KeyMaker<Map<String, T>> makeMap(Class<T> value) {
        Class<Map> c;
        Class<Map> c2 = c = Map.class;
        Map empty = Collections.EMPTY_MAP;
        KeyMaker<Map<String, T>> r = new KeyMaker<Map<String, T>>();
        r.type = c2;
        r.def = empty;
        r.elementType = value;
        return r;
    }

    public static <T> KeyMaker<Map<String, T>> makeSimpleMap(Class<T> element, Object ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        KeyMaker<Map<String, T>> r = new KeyMaker<Map<String, T>>();
        r.type = Map.class;
        r.elementType = element;
        LinkedHashMap<String, T> def = new LinkedHashMap<String, T>();
        for (int i = 0; i < pairs.length; i += 2) {
            String k = (String)pairs[i];
            T v = element.cast(pairs[i + 1]);
            def.put(k, v);
        }
        r.def = Collections.unmodifiableMap(def);
        return r;
    }

    public static <T> KeyMaker<Map<String, T>> makeModuleMap(Class<T> element, Object ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        KeyMaker<Map<String, T>> r = new KeyMaker<Map<String, T>>();
        r.type = Map.class;
        r.elementType = element;
        LinkedHashMap<String, Class> def = new LinkedHashMap<String, Class>();
        for (int i = 0; i < pairs.length; i += 2) {
            String k = (String)pairs[i];
            Class v = (Class)pairs[i + 1];
            def.put(k, v);
        }
        r.def = Collections.unmodifiableMap(def);
        return r;
    }

    public static <T> KeyMaker<T> makeNull(Class<T> type) {
        KeyMaker<T> km = new KeyMaker<T>();
        km.type = type;
        km.def = null;
        return km;
    }

    public static <T> KeyMaker<T> makeAuto(Class<T> type) {
        KeyMaker<T> km = new KeyMaker<T>();
        km.autoDetect = true;
        km.type = type;
        km.def = null;
        return km;
    }
}

