/*
 * Decompiled with CFR 0.152.
 */
package org.archive.state;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.archive.i18n.LocaleCache;
import org.archive.state.DuplicateKeyException;
import org.archive.state.InvalidKeyException;
import org.archive.state.Key;
import org.archive.state.KeyManagerData;
import org.archive.state.KeyTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyManager {
    private static Map<Class, KeyManagerData> keys = new ConcurrentHashMap<Class, KeyManagerData>(256, 0.75f, 1);

    private KeyManager() {
    }

    public static void addKeys(Class c) {
        if (KeyTypes.isSimple(c)) {
            return;
        }
        KeyManagerData kmd = keys.get(c);
        if (kmd != null) {
            return;
        }
        KeyManager.initialize(c);
        for (Class s = c.getSuperclass(); s != null; s = s.getSuperclass()) {
            KeyManager.addKeys(s);
        }
        TreeMap<String, Key<Object>> discovered = new TreeMap<String, Key<Object>>();
        discovered.putAll(KeyManager.getKeys(c.getSuperclass()));
        for (Field field : c.getDeclaredFields()) {
            if (!KeyManager.isKeyField(field)) continue;
            Key<Object> k = KeyManager.getKey(field);
            String name = field.getName().toLowerCase().replace('_', '-');
            k.setMetadata(c, field);
            Key<Object> old = discovered.put(name, k);
            if (old == null) continue;
            throw new DuplicateKeyException("duplicate key: " + name);
        }
        discovered = Collections.unmodifiableMap(discovered);
        kmd = new KeyManagerData(discovered);
        keys.put(c, kmd);
    }

    private static Key<Object> getKey(Field keyField) {
        try {
            Key r = (Key)keyField.get(null);
            if (r == null) {
                throw new IllegalStateException(keyField + " has no value.");
            }
            return r;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
    }

    static boolean isKeyField(Field f) {
        int mods = f.getModifiers();
        if (f.getType() != Key.class) {
            return false;
        }
        if (!Modifier.isStatic(mods)) {
            throw new InvalidKeyException("Non-static Key: " + f);
        }
        if (!Modifier.isPublic(mods)) {
            throw new InvalidKeyException("Non-public Key: " + f);
        }
        if (!Modifier.isFinal(mods)) {
            throw new InvalidKeyException("Non-final Key: " + f);
        }
        return true;
    }

    public static Map<String, Key<Object>> getKeys(Class c) {
        if (c == null) {
            return Collections.emptyMap();
        }
        if (KeyTypes.isSimple(c)) {
            return Collections.emptyMap();
        }
        KeyManager.initialize(c);
        KeyManagerData result = keys.get(c);
        if (result == null) {
            return Collections.emptyMap();
        }
        return result.keys;
    }

    private static void initialize(Class c) {
        try {
            Class.forName(c.getName(), true, c.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError();
        }
    }

    public static String getModuleDescription(Class<?> cls, Locale locale) {
        return LocaleCache.load(cls, locale).get("description");
    }
}

